<?php

/*
 * ==========================================================
 * MESSENGER APP
 * ==========================================================
 *
 * Facebook Messenger app main file. © 2017-2024 board.support. All rights reserved.
 *
 * 1. Send a message to the Facebook user in Messenger
 * 2. Convert  rich messages to Messenger rich messages
 * 3. Get the details of a Facebook user and add it to 
 * 4. Get the details of a Facebook page
 * 5. Receive and process the messages from Facebook Messenger forwarded by board.support
 * 6. Set typing status
 *
 */

define('SB_WAUNOFFICIAL', '1.5.4');

function sb_waunofficial_send_message($psid, $message = '', $attachments = [], $metadata = false)
{
    $wagateway = sb_waunofficial_get_device($metadata);
    if (!$wagateway) {
        return sb_error('unknown api', 'sb_waunofficial_send_message');
    }

    $provider = sb_isset($wagateway, 'waunofficial-provider', 'unknown');
    $apiKey = sb_isset($wagateway, 'waunofficial-apikey');
    $url = null;


    // Inisialisasi data untuk dikirim
    $datas = [];

    // Function to prepare data for Boostifyhub provider
    function prepareBoostifyhubData($apiKey, $psid, $message, $attachments)
    {
        $datas = [];
        foreach ($attachments as $index => $attachment) {
            $data = [
                'api_key' => $apiKey,
                'messageType' => 'text',
                'target' => $psid,
                'media' => $attachment[1],
                'content' => $index === 0 && !empty($message) ? $message : '.',
            ];
            $datas[] = $data;
        }
        return $datas;
    }

    // Function to prepare data for MPWA provider
    function prepareMpwaData($apiKey, $psid, $metadata, $message, $attachments)
    {
        $datas = [];
        foreach ($attachments as $index => $attachment) {
            $data = [
                'api_key' => $apiKey,
                'sender' => $metadata,
                'number' => $psid,
                'media_type' => detect_media_type($attachment[0]),
                'caption' => $index === 0 && !empty($message) ? $message : '.',
                'url' => $attachment[1]
            ];
            $datas[] = $data;
        }
        return $datas;
    }

    // Process based on provider
    if ($provider === 'boostifyhub') {
        $url = "https://api.boostifyhub.id/send";
        $datas = !empty($attachments) ? prepareBoostifyhubData($apiKey, $psid, $message, $attachments) : [
            [
                'api_key' => $apiKey,
                'messageType' => 'text',
                'target' => $psid,
                'content' => $message,
            ],
        ];
    } elseif ($provider === 'mpwa') {
        $baseurl = sb_isset($wagateway, 'waunofficial-baseurl');
        $url = !empty($attachments) ? $baseurl . "/send-media" : $baseurl . "/send-message";
        $datas = !empty($attachments) ? prepareMpwaData($apiKey, $psid, $metadata, $message, $attachments) : [
            [
                'api_key' => $apiKey,
                'sender' => $metadata,
                'number' => $psid,
                'message' => $message,
            ],
        ];
    }


    if ($url && !empty($datas)) {
        foreach ($datas as $data) {
            $options = [
                CURLOPT_URL => $url,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                ],
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POSTFIELDS => json_encode($data),
            ];

            $ch = curl_init();
            curl_setopt_array($ch, $options);
            $response = curl_exec($ch);
            curl_close($ch);
        }

        return json_encode(['message' => 'sent']);
    }

    return sb_error('missing-arguments', 'sb_waunofficial_send_message');
}




function detect_media_type($filename)
{
    // Ekstensi yang diizinkan
    $image_extensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp'];
    $video_extensions = ['mp4', 'avi', 'mov', 'wmv'];
    $audio_extensions = ['mp3', 'wav', 'ogg', 'flac'];
    $document_extensions = ['pdf', 'doc', 'docx', 'ppt', 'pptx', 'txt'];


    $extension = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    if (in_array($extension, $image_extensions)) {
        return 'image';
    } elseif (in_array($extension, $video_extensions)) {
        return 'video';
    } elseif (in_array($extension, $audio_extensions)) {
        return 'audio';
    } elseif (in_array($extension, $document_extensions)) {
        return 'document';
    } else {
        return 'unknown'; // Jika ekstensi tidak dikenali
    }
}





function sb_waunofficial_get_device($device)
{
    $devices = sb_get_setting('waunofficial', []);

    if (is_array($devices)) {
        for ($i = 0; $i < count($devices); $i++) {
            if ($devices[$i]['waunofficial-device'] == $device) {
                return $devices[$i];
            }
        }
    }
    return false;
}
