// src/options.ts
var resolveOptions = (options) => {
  var _a, _b;
  return {
    targets: options.targets,
    flatten: options.flatten ?? true,
    silent: options.silent ?? false,
    watch: {
      options: ((_a = options.watch) == null ? void 0 : _a.options) ?? {},
      reloadPageOnChange: ((_b = options.watch) == null ? void 0 : _b.reloadPageOnChange) ?? false
    }
  };
};

// node_modules/.pnpm/@polka+url@1.0.0-next.21/node_modules/@polka/url/build.mjs
import * as qs from "querystring";
function parse2(req) {
  let raw = req.url;
  if (raw == null)
    return;
  let prev = req._parsedUrl;
  if (prev && prev.raw === raw)
    return prev;
  let pathname = raw, search = "", query;
  if (raw.length > 1) {
    let idx = raw.indexOf("?", 1);
    if (idx !== -1) {
      search = raw.substring(idx);
      pathname = raw.substring(0, idx);
      if (search.length > 1) {
        query = qs.parse(search.substring(1));
      }
    }
  }
  return req._parsedUrl = { pathname, search, query, raw };
}

// node_modules/.pnpm/mrmime@1.0.1/node_modules/mrmime/index.mjs
var mimes = {
  "ez": "application/andrew-inset",
  "aw": "application/applixware",
  "atom": "application/atom+xml",
  "atomcat": "application/atomcat+xml",
  "atomdeleted": "application/atomdeleted+xml",
  "atomsvc": "application/atomsvc+xml",
  "dwd": "application/atsc-dwd+xml",
  "held": "application/atsc-held+xml",
  "rsat": "application/atsc-rsat+xml",
  "bdoc": "application/bdoc",
  "xcs": "application/calendar+xml",
  "ccxml": "application/ccxml+xml",
  "cdfx": "application/cdfx+xml",
  "cdmia": "application/cdmi-capability",
  "cdmic": "application/cdmi-container",
  "cdmid": "application/cdmi-domain",
  "cdmio": "application/cdmi-object",
  "cdmiq": "application/cdmi-queue",
  "cu": "application/cu-seeme",
  "mpd": "application/dash+xml",
  "davmount": "application/davmount+xml",
  "dbk": "application/docbook+xml",
  "dssc": "application/dssc+der",
  "xdssc": "application/dssc+xml",
  "es": "application/ecmascript",
  "ecma": "application/ecmascript",
  "emma": "application/emma+xml",
  "emotionml": "application/emotionml+xml",
  "epub": "application/epub+zip",
  "exi": "application/exi",
  "fdt": "application/fdt+xml",
  "pfr": "application/font-tdpfr",
  "geojson": "application/geo+json",
  "gml": "application/gml+xml",
  "gpx": "application/gpx+xml",
  "gxf": "application/gxf",
  "gz": "application/gzip",
  "hjson": "application/hjson",
  "stk": "application/hyperstudio",
  "ink": "application/inkml+xml",
  "inkml": "application/inkml+xml",
  "ipfix": "application/ipfix",
  "its": "application/its+xml",
  "jar": "application/java-archive",
  "war": "application/java-archive",
  "ear": "application/java-archive",
  "ser": "application/java-serialized-object",
  "class": "application/java-vm",
  "js": "application/javascript",
  "mjs": "application/javascript",
  "json": "application/json",
  "map": "application/json",
  "json5": "application/json5",
  "jsonml": "application/jsonml+json",
  "jsonld": "application/ld+json",
  "lgr": "application/lgr+xml",
  "lostxml": "application/lost+xml",
  "hqx": "application/mac-binhex40",
  "cpt": "application/mac-compactpro",
  "mads": "application/mads+xml",
  "webmanifest": "application/manifest+json",
  "mrc": "application/marc",
  "mrcx": "application/marcxml+xml",
  "ma": "application/mathematica",
  "nb": "application/mathematica",
  "mb": "application/mathematica",
  "mathml": "application/mathml+xml",
  "mbox": "application/mbox",
  "mscml": "application/mediaservercontrol+xml",
  "metalink": "application/metalink+xml",
  "meta4": "application/metalink4+xml",
  "mets": "application/mets+xml",
  "maei": "application/mmt-aei+xml",
  "musd": "application/mmt-usd+xml",
  "mods": "application/mods+xml",
  "m21": "application/mp21",
  "mp21": "application/mp21",
  "mp4s": "application/mp4",
  "m4p": "application/mp4",
  "doc": "application/msword",
  "dot": "application/msword",
  "mxf": "application/mxf",
  "nq": "application/n-quads",
  "nt": "application/n-triples",
  "cjs": "application/node",
  "bin": "application/octet-stream",
  "dms": "application/octet-stream",
  "lrf": "application/octet-stream",
  "mar": "application/octet-stream",
  "so": "application/octet-stream",
  "dist": "application/octet-stream",
  "distz": "application/octet-stream",
  "pkg": "application/octet-stream",
  "bpk": "application/octet-stream",
  "dump": "application/octet-stream",
  "elc": "application/octet-stream",
  "deploy": "application/octet-stream",
  "exe": "application/octet-stream",
  "dll": "application/octet-stream",
  "deb": "application/octet-stream",
  "dmg": "application/octet-stream",
  "iso": "application/octet-stream",
  "img": "application/octet-stream",
  "msi": "application/octet-stream",
  "msp": "application/octet-stream",
  "msm": "application/octet-stream",
  "buffer": "application/octet-stream",
  "oda": "application/oda",
  "opf": "application/oebps-package+xml",
  "ogx": "application/ogg",
  "omdoc": "application/omdoc+xml",
  "onetoc": "application/onenote",
  "onetoc2": "application/onenote",
  "onetmp": "application/onenote",
  "onepkg": "application/onenote",
  "oxps": "application/oxps",
  "relo": "application/p2p-overlay+xml",
  "xer": "application/patch-ops-error+xml",
  "pdf": "application/pdf",
  "pgp": "application/pgp-encrypted",
  "asc": "application/pgp-signature",
  "sig": "application/pgp-signature",
  "prf": "application/pics-rules",
  "p10": "application/pkcs10",
  "p7m": "application/pkcs7-mime",
  "p7c": "application/pkcs7-mime",
  "p7s": "application/pkcs7-signature",
  "p8": "application/pkcs8",
  "ac": "application/pkix-attr-cert",
  "cer": "application/pkix-cert",
  "crl": "application/pkix-crl",
  "pkipath": "application/pkix-pkipath",
  "pki": "application/pkixcmp",
  "pls": "application/pls+xml",
  "ai": "application/postscript",
  "eps": "application/postscript",
  "ps": "application/postscript",
  "provx": "application/provenance+xml",
  "cww": "application/prs.cww",
  "pskcxml": "application/pskc+xml",
  "raml": "application/raml+yaml",
  "rdf": "application/rdf+xml",
  "owl": "application/rdf+xml",
  "rif": "application/reginfo+xml",
  "rnc": "application/relax-ng-compact-syntax",
  "rl": "application/resource-lists+xml",
  "rld": "application/resource-lists-diff+xml",
  "rs": "application/rls-services+xml",
  "rapd": "application/route-apd+xml",
  "sls": "application/route-s-tsid+xml",
  "rusd": "application/route-usd+xml",
  "gbr": "application/rpki-ghostbusters",
  "mft": "application/rpki-manifest",
  "roa": "application/rpki-roa",
  "rsd": "application/rsd+xml",
  "rss": "application/rss+xml",
  "rtf": "application/rtf",
  "sbml": "application/sbml+xml",
  "scq": "application/scvp-cv-request",
  "scs": "application/scvp-cv-response",
  "spq": "application/scvp-vp-request",
  "spp": "application/scvp-vp-response",
  "sdp": "application/sdp",
  "senmlx": "application/senml+xml",
  "sensmlx": "application/sensml+xml",
  "setpay": "application/set-payment-initiation",
  "setreg": "application/set-registration-initiation",
  "shf": "application/shf+xml",
  "siv": "application/sieve",
  "sieve": "application/sieve",
  "smi": "application/smil+xml",
  "smil": "application/smil+xml",
  "rq": "application/sparql-query",
  "srx": "application/sparql-results+xml",
  "gram": "application/srgs",
  "grxml": "application/srgs+xml",
  "sru": "application/sru+xml",
  "ssdl": "application/ssdl+xml",
  "ssml": "application/ssml+xml",
  "swidtag": "application/swid+xml",
  "tei": "application/tei+xml",
  "teicorpus": "application/tei+xml",
  "tfi": "application/thraud+xml",
  "tsd": "application/timestamped-data",
  "toml": "application/toml",
  "trig": "application/trig",
  "ttml": "application/ttml+xml",
  "ubj": "application/ubjson",
  "rsheet": "application/urc-ressheet+xml",
  "td": "application/urc-targetdesc+xml",
  "vxml": "application/voicexml+xml",
  "wasm": "application/wasm",
  "wgt": "application/widget",
  "hlp": "application/winhlp",
  "wsdl": "application/wsdl+xml",
  "wspolicy": "application/wspolicy+xml",
  "xaml": "application/xaml+xml",
  "xav": "application/xcap-att+xml",
  "xca": "application/xcap-caps+xml",
  "xdf": "application/xcap-diff+xml",
  "xel": "application/xcap-el+xml",
  "xns": "application/xcap-ns+xml",
  "xenc": "application/xenc+xml",
  "xhtml": "application/xhtml+xml",
  "xht": "application/xhtml+xml",
  "xlf": "application/xliff+xml",
  "xml": "application/xml",
  "xsl": "application/xml",
  "xsd": "application/xml",
  "rng": "application/xml",
  "dtd": "application/xml-dtd",
  "xop": "application/xop+xml",
  "xpl": "application/xproc+xml",
  "xslt": "application/xml",
  "xspf": "application/xspf+xml",
  "mxml": "application/xv+xml",
  "xhvml": "application/xv+xml",
  "xvml": "application/xv+xml",
  "xvm": "application/xv+xml",
  "yang": "application/yang",
  "yin": "application/yin+xml",
  "zip": "application/zip",
  "3gpp": "video/3gpp",
  "adp": "audio/adpcm",
  "amr": "audio/amr",
  "au": "audio/basic",
  "snd": "audio/basic",
  "mid": "audio/midi",
  "midi": "audio/midi",
  "kar": "audio/midi",
  "rmi": "audio/midi",
  "mxmf": "audio/mobile-xmf",
  "mp3": "audio/mpeg",
  "m4a": "audio/mp4",
  "mp4a": "audio/mp4",
  "mpga": "audio/mpeg",
  "mp2": "audio/mpeg",
  "mp2a": "audio/mpeg",
  "m2a": "audio/mpeg",
  "m3a": "audio/mpeg",
  "oga": "audio/ogg",
  "ogg": "audio/ogg",
  "spx": "audio/ogg",
  "opus": "audio/ogg",
  "s3m": "audio/s3m",
  "sil": "audio/silk",
  "wav": "audio/wav",
  "weba": "audio/webm",
  "xm": "audio/xm",
  "ttc": "font/collection",
  "otf": "font/otf",
  "ttf": "font/ttf",
  "woff": "font/woff",
  "woff2": "font/woff2",
  "exr": "image/aces",
  "apng": "image/apng",
  "avif": "image/avif",
  "bmp": "image/bmp",
  "cgm": "image/cgm",
  "drle": "image/dicom-rle",
  "emf": "image/emf",
  "fits": "image/fits",
  "g3": "image/g3fax",
  "gif": "image/gif",
  "heic": "image/heic",
  "heics": "image/heic-sequence",
  "heif": "image/heif",
  "heifs": "image/heif-sequence",
  "hej2": "image/hej2k",
  "hsj2": "image/hsj2",
  "ief": "image/ief",
  "jls": "image/jls",
  "jp2": "image/jp2",
  "jpg2": "image/jp2",
  "jpeg": "image/jpeg",
  "jpg": "image/jpeg",
  "jpe": "image/jpeg",
  "jph": "image/jph",
  "jhc": "image/jphc",
  "jpm": "image/jpm",
  "jpx": "image/jpx",
  "jpf": "image/jpx",
  "jxr": "image/jxr",
  "jxra": "image/jxra",
  "jxrs": "image/jxrs",
  "jxs": "image/jxs",
  "jxsc": "image/jxsc",
  "jxsi": "image/jxsi",
  "jxss": "image/jxss",
  "ktx": "image/ktx",
  "ktx2": "image/ktx2",
  "png": "image/png",
  "btif": "image/prs.btif",
  "pti": "image/prs.pti",
  "sgi": "image/sgi",
  "svg": "image/svg+xml",
  "svgz": "image/svg+xml",
  "t38": "image/t38",
  "tif": "image/tiff",
  "tiff": "image/tiff",
  "tfx": "image/tiff-fx",
  "webp": "image/webp",
  "wmf": "image/wmf",
  "disposition-notification": "message/disposition-notification",
  "u8msg": "message/global",
  "u8dsn": "message/global-delivery-status",
  "u8mdn": "message/global-disposition-notification",
  "u8hdr": "message/global-headers",
  "eml": "message/rfc822",
  "mime": "message/rfc822",
  "3mf": "model/3mf",
  "gltf": "model/gltf+json",
  "glb": "model/gltf-binary",
  "igs": "model/iges",
  "iges": "model/iges",
  "msh": "model/mesh",
  "mesh": "model/mesh",
  "silo": "model/mesh",
  "mtl": "model/mtl",
  "obj": "model/obj",
  "stpz": "model/step+zip",
  "stpxz": "model/step-xml+zip",
  "stl": "model/stl",
  "wrl": "model/vrml",
  "vrml": "model/vrml",
  "x3db": "model/x3d+fastinfoset",
  "x3dbz": "model/x3d+binary",
  "x3dv": "model/x3d-vrml",
  "x3dvz": "model/x3d+vrml",
  "x3d": "model/x3d+xml",
  "x3dz": "model/x3d+xml",
  "appcache": "text/cache-manifest",
  "manifest": "text/cache-manifest",
  "ics": "text/calendar",
  "ifb": "text/calendar",
  "coffee": "text/coffeescript",
  "litcoffee": "text/coffeescript",
  "css": "text/css",
  "csv": "text/csv",
  "html": "text/html",
  "htm": "text/html",
  "shtml": "text/html",
  "jade": "text/jade",
  "jsx": "text/jsx",
  "less": "text/less",
  "markdown": "text/markdown",
  "md": "text/markdown",
  "mml": "text/mathml",
  "mdx": "text/mdx",
  "n3": "text/n3",
  "txt": "text/plain",
  "text": "text/plain",
  "conf": "text/plain",
  "def": "text/plain",
  "list": "text/plain",
  "log": "text/plain",
  "in": "text/plain",
  "ini": "text/plain",
  "dsc": "text/prs.lines.tag",
  "rtx": "text/richtext",
  "sgml": "text/sgml",
  "sgm": "text/sgml",
  "shex": "text/shex",
  "slim": "text/slim",
  "slm": "text/slim",
  "spdx": "text/spdx",
  "stylus": "text/stylus",
  "styl": "text/stylus",
  "tsv": "text/tab-separated-values",
  "t": "text/troff",
  "tr": "text/troff",
  "roff": "text/troff",
  "man": "text/troff",
  "me": "text/troff",
  "ms": "text/troff",
  "ttl": "text/turtle",
  "uri": "text/uri-list",
  "uris": "text/uri-list",
  "urls": "text/uri-list",
  "vcard": "text/vcard",
  "vtt": "text/vtt",
  "yaml": "text/yaml",
  "yml": "text/yaml",
  "3gp": "video/3gpp",
  "3g2": "video/3gpp2",
  "h261": "video/h261",
  "h263": "video/h263",
  "h264": "video/h264",
  "m4s": "video/iso.segment",
  "jpgv": "video/jpeg",
  "jpgm": "image/jpm",
  "mj2": "video/mj2",
  "mjp2": "video/mj2",
  "ts": "video/mp2t",
  "mp4": "video/mp4",
  "mp4v": "video/mp4",
  "mpg4": "video/mp4",
  "mpeg": "video/mpeg",
  "mpg": "video/mpeg",
  "mpe": "video/mpeg",
  "m1v": "video/mpeg",
  "m2v": "video/mpeg",
  "ogv": "video/ogg",
  "qt": "video/quicktime",
  "mov": "video/quicktime",
  "webm": "video/webm"
};
function lookup(extn) {
  let tmp = ("" + extn).trim().toLowerCase();
  let idx = tmp.lastIndexOf(".");
  return mimes[!~idx ? tmp : tmp.substring(++idx)];
}

// src/middleware.ts
import { statSync, createReadStream } from "node:fs";
import { resolve } from "node:path";

// src/utils.ts
import fastglob from "fast-glob";
import path from "node:path";
import fs from "fs-extra";
import pc from "picocolors";
import { createHash } from "node:crypto";
async function renameTarget(target, rename, src) {
  const parsedPath = path.parse(target);
  if (typeof rename === "string") {
    return rename;
  }
  return rename(parsedPath.name, parsedPath.ext.replace(".", ""), src);
}
var collectCopyTargets = async (root, targets, flatten) => {
  const copyTargets = [];
  for (const target of targets) {
    const { src, dest, rename, transform, preserveTimestamps, dereference } = target;
    const matchedPaths = await fastglob(src, {
      onlyFiles: false,
      dot: true,
      cwd: root
    });
    for (const matchedPath of matchedPaths) {
      if (transform) {
        const srcStat = await fs.stat(path.resolve(root, matchedPath));
        if (!srcStat.isFile()) {
          throw new Error(
            `"transform" option only supports a file: '${matchedPath}' is not a file`
          );
        }
      }
      const { base, dir } = path.parse(matchedPath);
      const destDir = flatten || !flatten && !dir ? dest : (
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        dir.replace(dir.split("/")[0], dest)
      );
      copyTargets.push({
        src: matchedPath,
        dest: path.join(
          destDir,
          rename ? await renameTarget(base, rename, matchedPath) : base
        ),
        transform,
        preserveTimestamps: preserveTimestamps ?? false,
        dereference: dereference ?? true
      });
    }
  }
  return copyTargets;
};
async function getTransformedContent(file, transform) {
  if (transform.encoding === "buffer") {
    const content2 = await fs.readFile(file);
    return transform.handler(content2, file);
  }
  const content = await fs.readFile(file, transform.encoding);
  return transform.handler(content, file);
}
async function transformCopy(transform, src, dest) {
  const transformedContent = await getTransformedContent(src, transform);
  if (transformedContent !== null) {
    await fs.outputFile(dest, transformedContent);
  }
}
var copyAll = async (rootSrc, rootDest, targets, flatten) => {
  const copyTargets = await collectCopyTargets(rootSrc, targets, flatten);
  for (const copyTarget of copyTargets) {
    const { src, dest, transform, preserveTimestamps, dereference } = copyTarget;
    const resolvedSrc = path.resolve(rootSrc, src);
    const resolvedDest = path.resolve(rootSrc, rootDest, dest);
    const transformOption = resolveTransformOption(transform);
    if (transformOption) {
      await transformCopy(transformOption, resolvedSrc, resolvedDest);
    } else {
      await fs.copy(resolvedSrc, resolvedDest, {
        preserveTimestamps,
        dereference
      });
    }
  }
  return copyTargets.length;
};
var updateFileMapFromTargets = (targets, fileMap) => {
  fileMap.clear();
  for (const target of [...targets].reverse()) {
    let dest = target.dest.replace(/\\/g, "/");
    if (!dest.startsWith("/")) {
      dest = `/${dest}`;
    }
    if (!fileMap.has(dest)) {
      fileMap.set(dest, []);
    }
    fileMap.get(dest).push({
      src: target.src,
      transform: target.transform
    });
  }
};
var calculateMd5Base64 = (content) => createHash("md5").update(content).digest("base64");
var formatConsole = (msg) => `${pc.cyan("[vite-plugin-static-copy]")} ${msg}`;
var outputCollectedLog = (logger, collectedMap) => {
  if (collectedMap.size > 0) {
    logger.info(
      formatConsole(pc.green(`Collected ${collectedMap.size} items.`))
    );
    if (process.env.DEBUG === "vite:plugin-static-copy") {
      for (const [key, vals] of collectedMap) {
        for (const val of vals) {
          logger.info(
            formatConsole(
              `  - '${key}' -> '${val.src}'${val.transform ? " (with content transform)" : ""}`
            )
          );
        }
      }
    }
  } else {
    logger.warn(formatConsole(pc.yellow("No items found.")));
  }
};
var outputCopyLog = (logger, copyCount) => {
  if (copyCount === void 0) {
    logger.error(formatConsole(pc.yellow("Copy count was not set.")));
  } else if (copyCount > 0) {
    logger.info(formatConsole(pc.green(`Copied ${copyCount} items.`)));
  } else {
    logger.warn(formatConsole(pc.yellow("No items to copy.")));
  }
};
function resolveTransformOption(transformOption) {
  if (typeof transformOption === "function") {
    return {
      handler: transformOption,
      encoding: "utf8"
    };
  }
  return transformOption;
}

// src/middleware.ts
function viaLocal(root, fileMap, uri) {
  if (uri.endsWith("/")) {
    uri = uri.slice(0, -1);
  }
  const files = fileMap.get(uri);
  if (files && files[0]) {
    const file = files[0];
    const filepath = resolve(root, file.src);
    const stats = statSync(filepath);
    return { filepath, stats, transform: file.transform };
  }
  for (const [key, vals] of fileMap) {
    const dir = key.endsWith("/") ? key : `${key}/`;
    if (!uri.startsWith(dir))
      continue;
    for (const val of vals) {
      const filepath = resolve(root, val.src, uri.slice(dir.length));
      try {
        const stats = statSync(filepath);
        return { filepath, stats };
      } catch {
      }
    }
    return void 0;
  }
  return void 0;
}
function getStaticHeaders(name, stats) {
  let ctype = lookup(name) || "";
  if (ctype === "text/html")
    ctype += ";charset=utf-8";
  const headers = {
    "Content-Length": stats.size,
    "Content-Type": ctype,
    "Last-Modified": stats.mtime.toUTCString(),
    ETag: `W/"${stats.size}-${stats.mtime.getTime()}"`,
    "Cache-Control": "no-cache"
  };
  return headers;
}
function getTransformHeaders(name, encoding, content) {
  let ctype = lookup(name) || "";
  if (ctype === "text/html")
    ctype += ";charset=utf-8";
  const headers = {
    "Content-Length": Buffer.byteLength(
      content,
      encoding === "buffer" ? void 0 : encoding
    ),
    "Content-Type": ctype,
    ETag: `W/"${calculateMd5Base64(content)}"`,
    "Cache-Control": "no-cache"
  };
  return headers;
}
function getMergeHeaders(headers, res) {
  headers = { ...headers };
  for (const key in headers) {
    const tmp = res.getHeader(key);
    if (tmp)
      headers[key] = tmp;
  }
  const contentTypeHeader = res.getHeader("content-type");
  if (contentTypeHeader) {
    headers["Content-Type"] = contentTypeHeader;
  }
  return headers;
}
function sendStatic(req, res, file, stats) {
  const staticHeaders = getStaticHeaders(file, stats);
  if (req.headers["if-none-match"] === staticHeaders["ETag"]) {
    res.writeHead(304);
    res.end();
    return;
  }
  let code = 200;
  const headers = getMergeHeaders(staticHeaders, res);
  const opts = {};
  if (req.headers.range) {
    code = 206;
    const [x, y] = req.headers.range.replace("bytes=", "").split("-");
    const end = (y ? parseInt(y, 10) : 0) || stats.size - 1;
    const start = (x ? parseInt(x, 10) : 0) || 0;
    opts.end = end;
    opts.start = start;
    if (start >= stats.size || end >= stats.size) {
      res.setHeader("Content-Range", `bytes */${stats.size}`);
      res.statusCode = 416;
      res.end();
      return;
    }
    headers["Content-Range"] = `bytes ${start}-${end}/${stats.size}`;
    headers["Content-Length"] = end - start + 1;
    headers["Accept-Ranges"] = "bytes";
  }
  res.writeHead(code, headers);
  createReadStream(file, opts).pipe(res);
}
async function sendTransform(req, res, file, transform) {
  const transformedContent = await getTransformedContent(file, transform);
  if (transformedContent === null) {
    return false;
  }
  const transformHeaders = getTransformHeaders(
    file,
    transform.encoding,
    transformedContent
  );
  if (req.headers["if-none-match"] === transformHeaders["ETag"]) {
    res.writeHead(304);
    res.end();
    return true;
  }
  const code = 200;
  const headers = getMergeHeaders(transformHeaders, res);
  res.writeHead(code, headers);
  res.end(transformedContent);
  return true;
}
function return404(res, next) {
  if (next) {
    next();
    return;
  }
  res.statusCode = 404;
  res.end();
}
function serveStaticCopyMiddleware(root, fileMap) {
  return async function viteServeStaticCopyMiddleware(req, res, next) {
    let pathname = parse2(req).pathname;
    if (pathname.includes("%")) {
      try {
        pathname = decodeURIComponent(pathname);
      } catch (err) {
      }
    }
    const data = viaLocal(root, fileMap, pathname);
    if (!data) {
      return404(res, next);
      return;
    }
    if (/\.[tj]sx?$/.test(pathname)) {
      res.setHeader("Content-Type", "application/javascript");
    }
    const transformOption = resolveTransformOption(data.transform);
    if (transformOption) {
      const sent = await sendTransform(req, res, data.filepath, transformOption);
      if (!sent) {
        return404(res, next);
        return;
      }
      return;
    }
    sendStatic(req, res, data.filepath, data.stats);
  };
}

// node_modules/.pnpm/throttle-debounce@5.0.0/node_modules/throttle-debounce/esm/index.js
function throttle(delay, callback, options) {
  var _ref = options || {}, _ref$noTrailing = _ref.noTrailing, noTrailing = _ref$noTrailing === void 0 ? false : _ref$noTrailing, _ref$noLeading = _ref.noLeading, noLeading = _ref$noLeading === void 0 ? false : _ref$noLeading, _ref$debounceMode = _ref.debounceMode, debounceMode = _ref$debounceMode === void 0 ? void 0 : _ref$debounceMode;
  var timeoutID;
  var cancelled = false;
  var lastExec = 0;
  function clearExistingTimeout() {
    if (timeoutID) {
      clearTimeout(timeoutID);
    }
  }
  function cancel(options2) {
    var _ref2 = options2 || {}, _ref2$upcomingOnly = _ref2.upcomingOnly, upcomingOnly = _ref2$upcomingOnly === void 0 ? false : _ref2$upcomingOnly;
    clearExistingTimeout();
    cancelled = !upcomingOnly;
  }
  function wrapper() {
    for (var _len = arguments.length, arguments_ = new Array(_len), _key = 0; _key < _len; _key++) {
      arguments_[_key] = arguments[_key];
    }
    var self = this;
    var elapsed = Date.now() - lastExec;
    if (cancelled) {
      return;
    }
    function exec() {
      lastExec = Date.now();
      callback.apply(self, arguments_);
    }
    function clear() {
      timeoutID = void 0;
    }
    if (!noLeading && debounceMode && !timeoutID) {
      exec();
    }
    clearExistingTimeout();
    if (debounceMode === void 0 && elapsed > delay) {
      if (noLeading) {
        lastExec = Date.now();
        if (!noTrailing) {
          timeoutID = setTimeout(debounceMode ? clear : exec, delay);
        }
      } else {
        exec();
      }
    } else if (noTrailing !== true) {
      timeoutID = setTimeout(debounceMode ? clear : exec, debounceMode === void 0 ? delay - elapsed : delay);
    }
  }
  wrapper.cancel = cancel;
  return wrapper;
}
function debounce(delay, callback, options) {
  var _ref = options || {}, _ref$atBegin = _ref.atBegin, atBegin = _ref$atBegin === void 0 ? false : _ref$atBegin;
  return throttle(delay, callback, {
    debounceMode: atBegin !== false
  });
}

// src/serve.ts
import chokidar from "chokidar";
import pc2 from "picocolors";
var servePlugin = ({
  targets,
  flatten,
  watch,
  silent
}) => {
  let config;
  let watcher;
  const fileMap = /* @__PURE__ */ new Map();
  const collectFileMap = async () => {
    try {
      const copyTargets = await collectCopyTargets(
        config.root,
        targets,
        flatten
      );
      updateFileMapFromTargets(copyTargets, fileMap);
    } catch (e) {
      config.logger.error(formatConsole(pc2.red(e.toString())));
    }
  };
  const collectFileMapDebounce = debounce(100, async () => {
    await collectFileMap();
  });
  return {
    name: "vite-plugin-static-copy:serve",
    apply: "serve",
    configResolved(_config) {
      config = _config;
    },
    async buildStart() {
      await collectFileMap();
    },
    configureServer({ httpServer, middlewares, ws }) {
      const reloadPage = () => {
        ws.send({ type: "full-reload", path: "*" });
      };
      watcher = chokidar.watch(
        targets.flatMap((target) => target.src),
        {
          cwd: config.root,
          ignoreInitial: true,
          ...watch.options
        }
      );
      watcher.on("add", async (path2) => {
        if (!silent) {
          config.logger.info(
            formatConsole(`${pc2.green("detected new file")} ${path2}`),
            {
              timestamp: true
            }
          );
        }
        await collectFileMapDebounce();
        if (watch.reloadPageOnChange) {
          reloadPage();
        }
      });
      if (watch.reloadPageOnChange) {
        watcher.on("change", (path2) => {
          if (!silent) {
            config.logger.info(
              formatConsole(`${pc2.green("file changed")} ${path2}`),
              {
                timestamp: true
              }
            );
          }
          reloadPage();
        });
        watcher.on("unlink", (path2) => {
          if (!silent) {
            config.logger.info(
              formatConsole(`${pc2.green("file deleted")} ${path2}`),
              {
                timestamp: true
              }
            );
          }
          reloadPage();
        });
      }
      if (!silent) {
        httpServer == null ? void 0 : httpServer.once("listening", () => {
          setTimeout(() => {
            outputCollectedLog(config.logger, fileMap);
          }, 0);
        });
      }
      return () => {
        middlewares.use(serveStaticCopyMiddleware(config.root, fileMap));
        const transformMiddlewareIndex = findMiddlewareIndex(
          middlewares.stack,
          "viteTransformMiddleware"
        );
        const serveStaticCopyMiddlewareIndex = findMiddlewareIndex(
          middlewares.stack,
          "viteServeStaticCopyMiddleware"
        );
        const serveStaticCopyMiddlewareItem = middlewares.stack.splice(
          serveStaticCopyMiddlewareIndex,
          1
        )[0];
        if (serveStaticCopyMiddlewareItem === void 0)
          throw new Error();
        middlewares.stack.splice(
          transformMiddlewareIndex,
          0,
          serveStaticCopyMiddlewareItem
        );
      };
    },
    async closeBundle() {
      await watcher.close();
    }
  };
};
var findMiddlewareIndex = (stack, name) => stack.findIndex(
  (middleware) => typeof middleware.handle === "function" && middleware.handle.name === name
);

// src/build.ts
var buildPlugin = ({
  targets,
  flatten,
  silent
}) => {
  let config;
  let copyCount;
  return {
    name: "vite-plugin-static-copy:build",
    apply: "build",
    configResolved(_config) {
      config = _config;
    },
    async writeBundle() {
      copyCount = await copyAll(
        config.root,
        config.build.outDir,
        targets,
        flatten
      );
    },
    closeBundle() {
      if (!silent)
        outputCopyLog(config.logger, copyCount);
    }
  };
};

// src/index.ts
var viteStaticCopy = (options) => {
  const resolvedOptions = resolveOptions(options);
  return [servePlugin(resolvedOptions), buildPlugin(resolvedOptions)];
};
export {
  viteStaticCopy
};
