<?php $__env->startSection('title'); ?>
    <?php echo e(__('Product')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php $__env->startComponent('common-components.breadcrumb'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(__('Invoice')); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('title_li'); ?>
        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <div class="row">
    <div class="col-lg-7">
        <div class="card">
            <div class="card-body p-4">
                <h4 class="card-title mb-4">
                    <i class="fa fa-credit-card me-2"></i> <?php echo e(__('Select Payment Method')); ?>

                </h4>

                <form action="<?php echo e(route('invoices.processPayment')); ?>" method="POST" autocomplete="off">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="invoice_id" value="<?php echo e($invoice->id); ?>">

                    <div class="row g-3">
                        <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentMethod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-12 col-md-6">
                                <label for="<?php echo e($paymentMethod->code); ?>"
                                    class="alert border-primary w-100 d-flex align-items-center"
                                    style="cursor: pointer">
                                    <input type="radio" name="payment_method" id="<?php echo e($paymentMethod->code); ?>"
                                        value="<?php echo e($paymentMethod->code); ?>">
                                    <img src="<?php echo e($paymentMethod->image); ?>" alt="" style="width: 60px"
                                        class="ms-3 flex-shrink-0">
                                    <div class="ms-3 text-dark w-100">
                                        <b><?php echo e($paymentMethod->name); ?></b>
                                        <p class="m-0 small border-bottom border-dark pb-1 mb-1">
                                            <?php echo e(__('Admin Fee')); ?>:
                                            Rp <?php echo e(number_format($paymentMethod->fee, 0, ',', '.')); ?>

                                        </p>
                                        <p class="m-0 small"><?php echo e(__('Total')); ?>:</p>
                                        <p class="m-0">
                                            <b>
                                                Rp <?php echo e(number_format($invoice->amount + $paymentMethod->fee, 0, ',', '.')); ?>

                                            </b>
                                        </p>
                                    </div>
                                </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="mb-3 alert border-warning w-100">
                        <label class="form-label"><?php echo e(__('Have a Promo Code?')); ?></label>
                        <input type="text" class="form-control" name="discount" value="">
                    </div>

                    <div class="text-end">
                        <button type="submit" class="btn btn-dark w-md">
                            <?php echo e(__('Continue')); ?>

                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

</div>

    <!-- end row -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master-layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/integrasichat.com/resources/views/invoices/payment.blade.php ENDPATH**/ ?>