<?php $__env->startSection('title'); ?>
    <?php echo e(__('Account Settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <!-- DataTables -->
    <link href="<?php echo e(URL::asset('/libs/datatables/datatables.min.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php $__env->startComponent('common-components.breadcrumb'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(__('Account Settings')); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('title_li'); ?>
        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title m-0"><i class="fa fa-cogs me-2"></i> <?php echo e(__('Account Settings')); ?></h4>
                </div>
                <div class="card-body p-4">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('account.updateSettings')); ?>" autocomplete="off">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="row">
                            <div class="col-md">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('Email')); ?> (<small class="text-muted"><?php echo e(__('Cannot be changed.')); ?></small>)
                                        <i class="ms-1 text-success fas fa-check-circle"></i></label>
                                    <span class="form-control"><?php echo e($user->email); ?></span>
                                </div>
                            </div>
                            <div class="col-md">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('WhatsApp Number')); ?> <i
                                            class="ms-1 text-success fas fa-check-circle"></i></label>
                                    <input type="text" class="form-control" name="whatsapp"
                                        value="<?php echo e(old('whatsapp', $user->whatsapp)); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('Full Name')); ?></label>
                                    <input type="text" class="form-control" name="name"
                                        value="<?php echo e(old('name', $user->name)); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('New Password')); ?></label>
                                    <input type="password" class="form-control" name="new_password">
                                    <small class="text-muted">*<?php echo e(__('Leave blank if not changing.')); ?></small>
                                </div>
                            </div>
                            <div class="col-md">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('Confirm New Password')); ?></label>
                                    <input type="password" class="form-control" name="new_password_confirmation">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('Password')); ?> (<small class="text-muted"><?php echo e(__('Enter your password to apply changes.')); ?></small>)</label>
                                    <input type="password" class="form-control" name="password">
                                    <?php if($errors->has('password')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('password')); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="float-end">
                            <button type="reset" class="btn btn-danger w-md"><?php echo e(__('Reset')); ?></button>
                            <button type="submit" class="btn btn-success w-md"><?php echo e(__('Save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- end row -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master-layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/integrasichat.com/resources/views/account/settings.blade.php ENDPATH**/ ?>