<header id="page-topbar">
    <div class="navbar-header">
        <div class="d-flex">
            <!-- LOGO -->
            <div class="navbar-brand-box">
                <a href="<?php echo e(route('dashboard')); ?>" class="logo logo-dark">
                    <span class="logo-sm">
                        <img src="<?php echo e(asset('images/logo-sm-dark.png')); ?>" alt="" height="30">
                    </span>
                    <span class="logo-lg">
                        <img src="<?php echo e(asset('images/logo-dark.png')); ?>" alt="" height="40">
                    </span>
                </a>

                <a href="<?php echo e(route('dashboard')); ?>" class="logo logo-light">
                    <span class="logo-sm">
                        <img src="<?php echo e(asset('images/logo-sm-dark.png')); ?>" alt="" height="30">
                    </span>
                    <span class="logo-lg">
                        <img src="<?php echo e(asset('images/logo-light.png')); ?>" alt="" height="50">
                    </span>
                </a>
            </div>

            <button type="button" class="btn btn-sm px-3 font-size-16 header-item toggle-btn waves-effect"
                id="vertical-menu-btn">
                <i class="fa fa-fw fa-bars"></i>
            </button>

            <div class="topnav">
                <nav class="navbar navbar-light navbar-expand-lg topnav-menu">

                    <div class="collapse navbar-collapse" id="topnav-menu-content">
                        <ul class="navbar-nav">
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle arrow-none" href="<?php echo e(route('dashboard')); ?>"
                                    id="topnav-dashboard" role="button">
                                    <?php echo e(__('Dashboard')); ?>

                                </a>
                            </li>

                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle arrow-none" href="<?php echo e(route('products.index')); ?>"
                                    id="topnav-dashboard" role="button">
                                    <?php if(auth()->guard()->check()): ?>
                                    <?php echo e(__('New Order')); ?>

                                    <?php else: ?>
                                    <?php echo e(__('Products')); ?>

                                    <?php endif; ?>
                                </a>
                            </li>

                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle arrow-none" href="<?php echo e(route('subscriptions.index')); ?>"
                                    id="topnav-dashboard" role="button">
                                    <?php echo e(__('My Subscriptions')); ?>

                                </a>
                            </li>
                            <li class="nav-item dropdown">
                                <a class="nav-link dropdown-toggle arrow-none" href="<?php echo e(route('invoices.index')); ?>"
                                    id="topnav-dashboard" role="button">
                                    <?php echo e(__('My Invoices')); ?>

                                </a>
                            </li>
                        </ul>
                    </div>
                </nav>
            </div>
        </div>

        <div class="d-flex">
            <div class="dropdown d-inline-block d-lg-none ml-2">
                <button type="button" class="btn header-item noti-icon waves-effect" id="page-header-search-dropdown"
                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="mdi mdi-magnify"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right p-0"
                    aria-labelledby="page-header-search-dropdown">

                    <form class="p-3">
                        <div class="form-group m-0">
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="<?php echo e(__('Search ...')); ?>"
                                    aria-label="Recipient's username">
                                <div class="input-group-append">
                                    <button class="btn btn-primary" type="submit"><i
                                            class="mdi mdi-magnify"></i></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="dropdown d-none d-sm-inline-block">
                <button type="button" class="btn header-item waves-effect" data-bs-toggle="dropdown" aria-haspopup="true"
                    aria-expanded="false">
                    <?php
                    $currentLocale = LaravelLocalization::getCurrentLocale();
                    $currentLocaleName = LaravelLocalization::getSupportedLocales()[$currentLocale]['name'];
                    ?>
                    <img src="/images/flags/<?php echo e(strtolower($currentLocaleName)); ?>.png" alt="Header Language"
                        height="16">
                    <span class="align-middle">
                        <?php echo e($currentLocaleName); ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-right">
                    <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $localeCode => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>"
                        class="dropdown-item notify-item">
                        <img src="/images/flags/<?php echo e(strtolower($properties['name'])); ?>.png" alt="user-image"
                            class="mr-1" height="12"> <span class="align-middle">
                            <?php echo e($properties['native']); ?></span>
                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <div class="dropdown d-none d-lg-inline-block ml-1">
                    <button type="button" class="btn header-item noti-icon waves-effect" data-toggle="fullscreen">
                        <i class="mdi mdi-fullscreen"></i>
                    </button>
                </div>

                <?php if(auth()->guard()->check()): ?>
                <div class="dropdown d-inline-block">
                    <button type="button" class="btn header-item waves-effect" id="page-header-user-dropdown"
                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <img class="rounded-circle header-profile-user"
                            src="<?php echo e(asset('images/users/avatar-2.jpg')); ?>" alt="Header Avatar">
                        <span class="d-none d-xl-inline-block ml-1"><?php echo e(Auth::user()->name); ?></span>
                        <i class="mdi mdi-chevron-down d-none d-xl-inline-block"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right">
                        <a class="dropdown-item d-block" href="<?php echo e(route('account.settings')); ?>">
                            <i class="bx bx-wrench font-size-16 align-middle mr-1"></i> <?php echo e(__('Account Settings')); ?>

                        </a>

                        <div class="dropdown-divider"></div>

                        <?php if(auth()->user() && auth()->user()->is_admin): ?>
                        <a class="dropdown-item d-block" href="<?php echo e(route('admin.dashboard')); ?>">
                            <i class="bx bx-dashboard font-size-16 align-middle mr-1"></i> <?php echo e(__('Admin Dashboard')); ?>

                        </a>
                        <?php endif; ?>

                        <div class="dropdown-divider"></div>

                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="dropdown-item text-danger">
                                <i class="bx bx-power-off font-size-16 align-middle mr-1 text-danger"></i> <?php echo e(__('Logout')); ?>

                            </button>
                        </form>
                    </div>
                </div>
                <?php endif; ?>

                <div class="dropdown d-inline-block">
                    <button type="button" class="btn header-item noti-icon right-bar-toggle waves-effect"
                        data-bs-toggle="offcanvas" data-bs-target="#offcanvasExample"
                        aria-controls="offcanvasExample">
                        <i class="mdi mdi-settings-outline"></i>
                    </button>
                </div>
            </div>
        </div>
</header>
<?php /**PATH /www/wwwroot/integrasichat.com/resources/views/layouts/hor-menu.blade.php ENDPATH**/ ?>