<?php $__env->startSection('title'); ?>
    <?php echo e(__('Products')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php $__env->startComponent('common-components.breadcrumb'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(__('Invoices')); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('title_li'); ?>
        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>
    <?php
        $paymentDetails = json_decode($invoice->payment_details, true);
    ?>
    <div class="row">
        <div class="col-lg-7">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title m-0"><i class="fa fa-receipt me-2"></i> <?php echo e(__('Invoice')); ?> #<?php echo e($invoice->invoice_number); ?>

                    </h4>
                </div>
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between flex-column flex-md-row">
                        <div class="mb-3">
                            <h2 class="m-0"><?php echo e(config('app.name')); ?></h2>
                            <p class="m-0">PT CITRA SELARAS INTEGRASI</p>
                        </div>
                        <div class="">
                            <table>
                                <tbody>
                                    <tr>
                                        <td class="align-top"><?php echo e(__('To')); ?></td>
                                        <td class="align-top px-1">:</td>
                                        <td class="align-top">
                                            <b><?php echo e($invoice->user->name); ?><br><?php echo e($invoice->user->email); ?></b>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="align-top"><?php echo e(__('Date')); ?></td>
                                        <td class="align-top px-1">:</td>
                                        <td class="align-top">
                                            <b><?php echo e($invoice->created_at->format('d F Y H:i')); ?></b>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="align-top"><?php echo e(__('Due Date')); ?></td>
                                        <td class="align-top px-1">:</td>
                                        <td class="align-top">
                                            <b><?php echo e($invoice->expired_at); ?></b>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="align-top"><?php echo e(__('Payment Method')); ?></td>
                                        <td class="align-top px-1">:</td>
                                        <td class="align-top">
                                            <b><?php echo e($paymentDetails['type']); ?></b>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php if($invoice->status == 'unpaid'): ?>
                        <div class="my-4 alert alert-warning bg-soft-warning text-center text-uppercase">
                            <b><?php echo e(__('Unpaid')); ?></b>
                        </div>
                    <?php elseif($invoice->status == 'paid'): ?>
                        <div class="my-4 alert alert-success bg-soft-success text-center text-uppercase">
                            <b><?php echo e(__('Paid')); ?></b>
                        </div>
                    <?php else: ?>
                        <div class="my-4 alert  alert-danger bg-soft-danger text-center text-uppercase">
                            <b><?php echo e(__('Cancelled')); ?></b>
                        </div>
                    <?php endif; ?>

                    <div class="table-responsive">
                        <table class="table table-bordered mb-0">
                            <tbody>
                                <tr>
                                    <th><?php echo e(__('Description')); ?></th>
                                    <th><?php echo e(__('Amount')); ?></th>
                                </tr>
                                <tr>
                                    <td><?php echo e($invoice->description); ?></td>
                                    <td>Rp <?php echo e(number_format($invoice->amount, 0, ',', '.')); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-end"><b><?php echo e(__('Subtotal')); ?></b></td>
                                    <td>Rp <?php echo e(number_format($invoice->amount, 0, ',', '.')); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-end"><b><?php echo e(__('Admin Fee')); ?></b></td>
                                    <td>Rp <?php echo e(number_format($invoice->tax, 0, ',', '.')); ?></td>
                                </tr>
                                <tr>
                                    <td class="text-end"><b><?php echo e(__('Total')); ?></b></td>
                                    <td>Rp <?php echo e(number_format($invoice->amount + $invoice->tax, 0, ',', '.')); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <?php if($invoice->status == 'unpaid'): ?>
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title m-0"><i class="fa fa-question me-2"></i> <?php echo e(__('Payment Instructions')); ?>

                        </h4>
                    </div>
                    <div class="card-body overflow-hidden position-relative p-4">
                        <div>
                            <i class="bx bx-help-circle widget-box-1-icon text-primary"></i>
                        </div>
                        <div class="text-center">
   <?php if(!empty($paymentDetails['qr_code'])): ?>
                        
                        <p><?php echo e(__('Scan this QR Code to pay')); ?></p>
                        <img src="https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=<?php echo e(urlencode($paymentDetails['qr_code'])); ?>" alt="QR Code" class="img-fluid" />
                    <?php elseif(isset($paymentDetails['paymentUrl'])): ?>
                        
                        <a target="_blank" href="<?php echo e($paymentDetails['paymentUrl']); ?>" class="btn btn-primary btn-sm text-white">
                            <?php echo e(__('Click here to pay')); ?>

                        </a>
                    <?php else: ?>
                        
                        <h4 class="m-0"><?php echo e(__('Bank')); ?>: <?php echo e($paymentDetails['bank_account']); ?></h4>
                        <h4 class="m-0"><?php echo e(__('Account Name')); ?>: <?php echo e($paymentDetails['bank_account_name']); ?></h4>
                    <?php endif; ?>
</div>

                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master-layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/integrasichat.com/resources/views/invoices/detail.blade.php ENDPATH**/ ?>