<?php $__env->startSection('title'); ?>
    <?php echo e(__('Dashboard')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <!-- DataTables -->
    <link href="<?php echo e(URL::asset('/libs/datatables/datatables.min.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <?php $__env->startComponent('common-components.breadcrumb'); ?>
            <?php $__env->slot('title'); ?>
                <?php echo e(__('Dashboard')); ?>

            <?php $__env->endSlot(); ?>
            <?php $__env->slot('title_li'); ?>
            <?php $__env->endSlot(); ?>
        <?php echo $__env->renderComponent(); ?>

        <div class="card card-body">
            <div class="d-flex align-items-center">
                <img src="https://upload.wikimedia.org/wikipedia/commons/5/5e/WhatsApp_icon.png" alt="WhatsApp" width="50px">
                <div class="ms-2">
                    <?php echo e(__('Join the group')); ?> <?php echo e(config('app.name')); ?> <?php echo e(__('on WhatsApp to get updates, promotions, etc.')); ?><br>
                    <a href="#" target="_blank"><?php echo e(__('Click Here to Join')); ?></a>
                </div>
            </div>
        </div>

        <div class="row">
            <?php if($firstUnpaidPayment): ?>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title m-0"><i class="fa fa-exclamation-circle me-2"></i> <?php echo e(__('Unpaid Invoice')); ?></h4>
                        </div>
                        <div class="card-body p-4">
                            <div class="row">
                                <div class="col-md-6 col-lg-12">
                                    <div class="card">
                                        <div class="card-header d-flex justify-content-between align-items-center">
                                            <h4 class="card-title m-0"><i class="fa fa-receipt me-2"></i> <?php echo e(__('Invoice')); ?> #<?php echo e($firstUnpaidPayment->id); ?></h4>
                                            <p class="m-0 text-success fw-bold">Rp
                                                <?php echo e(number_format($firstUnpaidPayment->amount + $firstUnpaidPayment->tax, 0, ',', '.')); ?>

                                            </p>
                                        </div>
                                        <div class="card-body overflow-hidden position-relative p-4">
                                            <div>
                                                <i class="fa fa-receipt widget-box-1-icon text-primary"></i>
                                            </div>
                                            <h6><?php echo e(__('Deadline:')); ?></h6>
                                            <p><?php echo e(\Carbon\Carbon::parse($firstUnpaidPayment->expired_at)->format('d M Y H:i')); ?></p>
                                            <h6><?php echo e(__('Description:')); ?></h6>
                                            <p><?php echo e($firstUnpaidPayment->description); ?></p>
                                            <a class="btn btn-sm btn-secondary w-100"
                                                href="<?php echo e(route('invoices.payment', $firstUnpaidPayment->invoice_number)); ?>"><?php echo e(__('Pay Now')); ?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <a href="<?php echo e(route('invoices.index')); ?>" class="btn btn-sm btn-primary w-100"><?php echo e(__('View All')); ?></a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="col-lg">
                <div class="row">
                    <div class="col-md">
                        <div class="card">
                            <div class="card-body overflow-hidden position-relative">
                                <div>
                                    <i class="fa fa-boxes widget-box-1-icon text-primary"></i>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <span><?php echo e(__('Active Subscription')); ?></span>
                                        <h4 class="mt-2"><?php echo e($user->activeSubscriptionCount); ?></h4>
                                    </div>
                                    <div class="text-end">
                                        <i class="fa fa-fw fa-2x fa-boxes text-primary"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md">
                        <div class="card">
                            <div class="card-body overflow-hidden position-relative">
                                <div>
                                    <i class="fa fa-boxes widget-box-1-icon text-success"></i>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <span><?php echo e(__('Inactive Subscription')); ?></span>
                                        <h4 class="mt-2"><?php echo e($user->inactiveSubscriptionCount); ?></h4>
                                    </div>
                                    <div class="text-end">
                                        <i class="fa fa-fw fa-2x fa-boxes text-success"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md">
                        <div class="card">
                            <div class="card-body overflow-hidden position-relative">
                                <div>
                                    <i class="fa fa-boxes widget-box-1-icon text-secondary"></i>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <span><?php echo e(__('Unpaid Invoice')); ?></span>
                                        <h4 class="mt-2"><?php echo e($user->unpaidPaymentCount); ?></h4>
                                    </div>
                                    <div class="text-end">
                                        <i class="fa fa-fw fa-2x fa-boxes text-secondary"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="card">
                            <div class="card-body overflow-hidden position-relative">
                                <div>
                                    <i class="fa fa-globe widget-box-1-icon text-primary"></i>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <span><?php echo e(__('Paid Invoice')); ?></span>
                                        <h4 class="mt-2"><?php echo e($user->paidPaymentCount); ?></h4>
                                    </div>
                                    <div class="text-end">
                                        <i class="fa fa-fw fa-2x fa-globe text-primary"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- end row -->
<?php $__env->stopSection(); ?>
<!-- Modal untuk menampilkan detail langganan -->

<?php $__env->startSection('script'); ?>
    <!-- Required datatable js -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master-layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/integrasichat.com/resources/views/dashboard.blade.php ENDPATH**/ ?>