<?php $__env->startSection('title', 'Subscriptions List'); ?>
<?php $__env->startPush('css'); ?>
<!-- DataTables -->
<link href="<?php echo e(URL::asset('build/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
<link href="<?php echo e(URL::asset('build/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />

<!-- Responsive datatable examples -->
<link href="<?php echo e(URL::asset('build/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startComponent('common-components.breadcrumb'); ?>
<?php $__env->slot('title'); ?>
Subscriptions
<?php $__env->endSlot(); ?>
<?php $__env->slot('title_li'); ?>
List
<?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<div class="card">
    <div class="card-body">
        <table class="table table-bordered dt-responsive data-table nowrap" style="width: 100%;">
            <thead>
                <tr>
                    <th>#</th>
                    <th>User</th>
                    <th>Domain</th>
                    <th>Product</th>
                    <th>Status</th>
                    <th>Start Date</th>
                    <th>Due Date</th>
                    <th>Invoice Terakhir</th>
                    <th>Actions</th>
                </tr>
            </thead>
        </table>
    </div>
</div>

<?php $__env->startPush('script'); ?>
<!-- Required datatable js -->
<script src="<?php echo e(URL::asset('build/libs/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<!-- Buttons examples -->
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons-bs4/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/jszip/jszip.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/pdfmake/build/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/pdfmake/build/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons/js/buttons.colVis.min.js')); ?>"></script>
<!-- Responsive examples -->
<script src="<?php echo e(URL::asset('build/libs/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>

<!-- Datatable init js -->
<script src="<?php echo e(URL::asset('build/js/pages/datatables.init.js')); ?>"></script>
<script type="text/javascript">
    $(function() {
        var table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(route('admin.subscriptions.index')); ?>",
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'user',
                    name: 'user'
                },
                {
                    data: 'domain',
                    name: 'domain'
                },
                {
                    data: 'product',
                    name: 'product'
                },
                {
                    data: 'status',
                    name: 'status',
                    render: function(data) {
                        let badgeClass = '';

                        switch (data) {
                            case 'active':
                                badgeClass = 'bg-success';
                                break;
                            case 'inactive':
                                badgeClass = 'bg-danger';
                                break;
                            case 'suspend':
                                badgeClass = 'bg-warning text-dark';
                                break;
                            case 'waiting':
                                badgeClass = 'bg-info text-dark';
                                break;
                            default:
                                badgeClass = 'bg-primary';
                        }

                        return `<span class="badge ${badgeClass}">${data.charAt(0).toUpperCase() + data.slice(1)}</span>`;
                    }
                },
                {
                    data: 'start_date',
                    name: 'start_date'
                },
                {
                    data: 'due_date',
                    name: 'due_date'
                },
                {
                    data: 'last_payment',
                    name: 'last_payment',
                    orderable: false,
                    searchable: false

                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                },
            ]
        });
    });

    $(document).on('click', '.delete', function() {

        const url = $(this).attr('data-url');
        confirmAction(
            "Anda yakin?",
            "Data terkait akan terhapus secara permanen!",
            function() {
                $.ajax({
                    url: url,
                    type: 'DELETE',
                    success: function(response) {
                        // Refresh DataTable setelah berhasil menghapus
                        $('.data-table').DataTable().ajax.reload();
                        Swal.fire({
                            title: "Success!",
                            text: "Subscription has been deleted.",
                            icon: "success",
                        });
                    },
                    error: function(xhr) {
                        Swal.fire("Error deleting subscirption: " + xhr.responseText, {
                            icon: "error",
                        });
                    }
                });
            },
            function() {
                Swal.fire("Canceled,safe!", {
                    icon: "error",
                    text: "Canceled,safe!.",
                });

            }
        );
    });
</script>
<?php $__env->stopPush(); ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/integrasichat.com/resources/views/admin/subscriptions/index.blade.php ENDPATH**/ ?>