<?php $__env->startSection('title'); ?>
<?php echo e(__('My Subscriptions')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
<!-- DataTables -->
<link href="<?php echo e(URL::asset('build/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
<link href="<?php echo e(URL::asset('build/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />

<!-- Responsive datatable examples -->
<link href="<?php echo e(URL::asset('build/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startComponent('common-components.breadcrumb'); ?>
<?php $__env->slot('title'); ?>
<?php echo e(__('My Subscriptions')); ?>

<?php $__env->endSlot(); ?>
<?php $__env->slot('title_li'); ?>
<?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">

                <h4 class="card-title"><?php echo e(__('Subscriptions')); ?></h4>
                <p class="card-title-desc"><?php echo e(__('All subscriptions related to your account will be displayed here.')); ?></p>

                <table id="datatable-buttons" class="table table-bordered dt-responsive nowrap"
                    style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(__('Order Date')); ?></th>
                            <th><?php echo e(__('Domain')); ?></th>
                            <th><?php echo e(__('Product')); ?></th>
                            <th><?php echo e(__('Active Date')); ?></th>
                            <th><?php echo e(__('Due Date')); ?></th>
                            <th><?php echo e(__('Last Invoice')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>

                        </tr>
                    </thead>

                    <tbody>

                        <?php $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($subscription->id); ?></td>
                            <td><?php echo e($subscription->created_at->format('d M Y')); ?></td>
                            <td><?php echo e($subscription->domain); ?><br>
                                <?php if($subscription->ns): ?>
                                <span class="text-muted"><?php echo e(__('Nameserver:')); ?></span><br>
                                <?php $__currentLoopData = explode(',', $subscription->ns); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ns): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge badge-light"><?php echo e($ns); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($subscription->product); ?></td>
                            <td><?php echo e($subscription->start_date ? \Carbon\Carbon::parse($subscription->start_date)->format('d M Y') : '-'); ?></td>
                            <td><?php echo e($subscription->due_date ? \Carbon\Carbon::parse($subscription->due_date)->format('d M Y') : '-'); ?></td>

                            <td>
                                <a href="<?php echo e(route('invoices.detail', $subscription->lastPayment->invoice_number)); ?>"
                                    class="text-primary"><?php echo e($subscription->lastPayment->invoice_number); ?></a>
                            </td>
                            <td>
                                <?php if($subscription->status == 'waiting'): ?>
                                <span class="badge bg-warning"><?php echo e(__('Waiting')); ?></span>
                                <?php elseif($subscription->status == 'active'): ?>
                                <span class="badge bg-success"><?php echo e(__('Active')); ?></span>
                                <?php elseif($subscription->status == 'processing'): ?>
                                <span class="badge bg-info"><?php echo e(__('Processing')); ?></span>
                                <?php else: ?>
                                <span class="badge bg-danger"><?php echo e(__('Suspended/Inactive')); ?></span>
                                <?php endif; ?>
                            </td>

                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
<!-- Required datatable js -->
<script src="<?php echo e(URL::asset('build/libs/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<!-- Buttons examples -->
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons-bs4/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/jszip/jszip.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/pdfmake/build/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/pdfmake/build/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons/js/buttons.colVis.min.js')); ?>"></script>
<!-- Responsive examples -->
<script src="<?php echo e(URL::asset('build/libs/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>

<!-- Datatable init js -->
<script src="<?php echo e(URL::asset('build/js/pages/datatables.init.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master-layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/integrasichat.com/resources/views/subscriptions/index.blade.php ENDPATH**/ ?>