<!DOCTYPE html>
<html lang="en">

<head>


    <?php echo $__env->make('landing.title-meta', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php echo $__env->make('landing.head-css', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

</head>

<body>

    <?php echo $__env->make('landing.nav-dark', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- =========== Hero Section Start =========== -->
    <section
        class="relative pt-32 pb-32 overflow-x-hidden from-slate-500/10 bg-[url(../images/home/bg-1.png)] bg-no-repeat bg-cover"
        id="home">
        <div class="container">

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 gap-6 items-center">
                <div class="text-sm py-20 px-10">
                    <span
                        class="inline-flex py-2 text-lg text-black font-medium items-center justify-center rounded-full">
                        <i data-lucide="minus"></i>Solusi Omnichannel No.1 untuk Bisnis Modern</span>
                    <h1 class="md:text-6xl/tight text-4xl text-dark tracking-normal leading-normal font-bold mb-4 mt-6">
                        Maksimalkan pertumbuhan bisnis dengan <span class="text-primary">IntegrasiChat</span></h1>
                    <p class="text-base font-medium text-muted leading-7 mt-5 capitalize">
                        Satu dashboard untuk mengelola semua pesan dari WhatsApp, Instagram, Telegram hingga Facebook — plus, ciptakan customer service AI canggih sesuai kebutuhan brand Anda.
                    </p>
                    <div class="flex flex-wrap items-center justify-center gap-3 lg:justify-normal mt-9">
                        <a href="https://wa.me/6282140046501" target="_blank" rel="noopener noreferrer">
                            <button class="bg-green-500 hover:bg-green-600 text-white font-semibold py-2 px-4 rounded-xl shadow-md">
                                Konsultasi via WhatsApp
                            </button>
                        </a>
                        <a href="/products">
                            <button class="bg-blue-500 hover:bg-blue-600 text-white font-semibold py-2 px-4 rounded-xl shadow-md">
                                Trial Gratis
                            </button>
                        </a>
                    </div>

                </div>


                <div class="mt-4 pt-2 sm:mt-0 sm:pt-0 relative">
                    <img loading="lazy" src="/landing/images/live-chat.gif" alt=""
                        class="h-[600px] max-w-full mx-auto rounded-xl shadow-2xl" />

                    <div class="absolute bottom-3/4 -end-8 2xl:end-8 hidden xl:block">

                    </div>


                    <div class="absolute bottom-28 start-6 hidden xl:block">
                        <div class="flex items-center gap-2 p-2 pe-6 rounded-full bg-white shadow-2xl">
                            <div class="rounded-full bg-primary h-9 w-9 items-center justify-center flex">
                                <i data-lucide="headset" class="h-6 w-6 text-white"></i>
                            </div>
                            <div class="">
                                <h6 class="text-base font-medium text-default-900">24x7 Customer Support</h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

    <!-- Services Start -->
    <section id="services" class="py-20">
        <div class="container">
            <div class="max-w-2xl mx-auto text-center">
                <span
                    class="text-sm text-primary uppercase font-semibold tracking-wider text-default-950">Services</span>
                <h2 class="text-3xl md:text-4xl/tight font-semibold text-black mt-4">Build a customer - centric
                    marketing strategy</h2>
                <p class="text-base font-medium mt-4 text-muted">Ligula risus auctor tempus magna feugit lacinia.</p>
            </div>

            <div
                class="grid lg:grid-cols-4 md:grid-cols-2 grid-cols-1 gap-x-3 gap-y-6 md:gap-y-12 lg:gap-y-24 md:pt-20 pt-12">
                <div class="text-center">
                    <div class="flex items-center justify-center">
                        <div class="items-center justify-center flex bg-primary/10 rounded-[49%_80%_40%_90%_/_50%_30%_70%_80%] h-20 w-20 border">
                            <i data-lucide="menu" class="h-10 w-10 text-primary"></i>
                        </div>
                    </div>
                    <h1 class="text-xl font-semibold pt-4">Omnichannel Dashboard</h1>
                    <p class="text-base text-gray-600 mt-2">Kelola semua pesan dari WhatsApp, Instagram, Facebook, dan live chat dalam satu tempat.</p>
                </div>

                <div class="text-center">
                    <div class="flex items-center justify-center">
                        <div class="items-center justify-center flex bg-primary/10 rounded-[49%_80%_40%_90%_/_50%_30%_70%_80%] h-20 w-20 border">
                            <i data-lucide="lightbulb" class="h-10 w-10 text-primary"></i>
                        </div>
                    </div>
                    <h1 class="text-xl font-semibold pt-4">AI Customer Assistant</h1>
                    <p class="text-base text-gray-600 mt-2">Buat AI yang paham bisnis Anda. Latih dengan data training, flow, dan knowledge base.</p>
                </div>

                <div class="text-center">
                    <div class="flex items-center justify-center">
                        <div class="items-center justify-center flex bg-primary/10 rounded-[49%_80%_40%_90%_/_50%_30%_70%_80%] h-20 w-20 border">
                            <i data-lucide="bar-chart-big" class="h-10 w-10 text-primary"></i>
                        </div>
                    </div>
                    <h1 class="text-xl font-semibold pt-4">Multi-Agent & Antrian</h1>
                    <p class="text-base text-gray-600 mt-2">Distribusikan pesan otomatis ke banyak agen. Sistem antrian dan prioritas built-in.</p>
                </div>

                <div class="text-center">
                    <div class="flex items-center justify-center">
                        <div class="items-center justify-center flex bg-primary/10 rounded-[49%_80%_40%_90%_/_50%_30%_70%_80%] h-20 w-20 border">
                            <i data-lucide="codepen" class="h-10 w-10 text-primary"></i>
                        </div>
                    </div>
                    <h1 class="text-xl font-semibold pt-4">Integrasi Fleksibel</h1>
                    <p class="text-base text-gray-600 mt-2">Hubungkan dengan sistem Anda melalui API, webhook, dan integrasi third-party yang mudah.</p>
                </div>

                <div class="text-center">
                    <div class="flex items-center justify-center">
                        <div class="items-center justify-center flex bg-primary/10 rounded-[49%_80%_40%_90%_/_50%_30%_70%_80%] h-20 w-20 border">
                            <i data-lucide="shield" class="h-10 w-10 text-primary"></i>
                        </div>
                    </div>
                    <h1 class="text-xl font-semibold pt-4">Department Routing</h1>
                    <p class="text-base text-gray-600 mt-2">Pisahkan pesan ke departemen berbeda: sales, support, billing—semua otomatis.</p>
                </div>

                <div class="text-center">
                    <div class="flex items-center justify-center">
                        <div class="items-center justify-center flex bg-primary/10 rounded-[49%_80%_40%_90%_/_50%_30%_70%_80%] h-20 w-20 border">
                            <i data-lucide="rocket" class="h-10 w-10 text-primary"></i>
                        </div>
                    </div>
                    <h1 class="text-xl font-semibold pt-4">Live Chat Web</h1>
                    <p class="text-base text-gray-600 mt-2">Pasang live chat di website Anda dan arahkan pesannya langsung ke dashboard utama.</p>
                </div>

                <div class="text-center">
                    <div class="flex items-center justify-center">
                        <div class="items-center justify-center flex bg-primary/10 rounded-[49%_80%_40%_90%_/_50%_30%_70%_80%] h-20 w-20 border">
                            <i data-lucide="layers-2" class="h-10 w-10 text-primary"></i>
                        </div>
                    </div>
                    <h1 class="text-xl font-semibold pt-4">Role & Permissions</h1>
                    <p class="text-base text-gray-600 mt-2">Atur hak akses user: admin, supervisor, agen. Fleksibel sesuai struktur tim Anda.</p>
                </div>

                <div class="text-center">
                    <div class="flex items-center justify-center">
                        <div class="items-center justify-center flex bg-primary/10 rounded-[49%_80%_40%_90%_/_50%_30%_70%_80%] h-20 w-20 border">
                            <i data-lucide="webcam" class="h-10 w-10 text-primary"></i>
                        </div>
                    </div>
                    <h1 class="text-xl font-semibold pt-4">Insight & Analytics</h1>
                    <p class="text-base text-gray-600 mt-2">Lihat laporan performa tim, response rate, jam sibuk, dan semua metrik penting Anda.</p>
                </div>

            </div>

        </div>
    </section>
    <!-- Services End -->

    <!-- Feature Start -->
    <section id="features" class="py-20">
        <div class="container">

            <div class="grid lg:grid-cols-2 items-center gap-6">
                <div class="flex items-center">
                    <img loading="lazy" src="/landing/images/message.png" class="h-[650px] rounded-xl mx-auto shadow-lg" alt="feature section">
                </div>

                <div class="lg:ms-5 ms-8">
                    <span class="text-sm text-primary uppercase font-semibold tracking-wider text-default-950">
                        Focused on Achieving
                    </span>
                    <h2 class="text-3xl md:text-4xl/tight font-semibold text-black mt-4">
                        Meningkatkan keterlibatan pelanggan
                    </h2>

                    <hr class="border-gray-200 my-6" />

                    <!-- Feature 1 -->
                    <div class="flex items-start gap-5">
                        <div>
                            <div
                                class="w-12 h-12 rounded-full border border-dashed border-primary/40 bg-primary/10 flex items-center justify-center">
                                <i data-lucide="smartphone" class="text-base text-blue-600"></i>
                            </div>
                        </div>

                        <div>
                            <h4 class="text-xl font-semibold">Akses dari Mana Saja</h4>
                            <p class="text-base font-normal text-gray-500 mt-2">
                                Sistem PWA dan installer memungkinkan balasan pesan customer tanpa batasan perangkat.
                            </p>
                        </div>
                    </div>

                    <!-- Feature 2 -->
                    <div class="flex items-start gap-5 mt-8">
                        <div>
                            <div
                                class="w-12 h-12 rounded-full border border-dashed border-primary/40 bg-primary/10 flex items-center justify-center">
                                <i data-lucide="bell" class="text-base text-blue-600"></i>
                            </div>
                        </div>

                        <div>
                            <h4 class="text-xl font-semibold">Notifikasi Realtime & Email Piping</h4>
                            <p class="text-base font-normal text-gray-500 mt-2">
                                Pastikan setiap pesan customer terpantau dan terbalas dengan sistem notifikasi dan integrasi email.
                            </p>
                        </div>
                    </div>

                    <!-- Feature 3 -->
                    <div class="flex items-start gap-5 mt-8">
                        <div>
                            <div
                                class="w-12 h-12 rounded-full border border-dashed border-primary/40 bg-primary/10 flex items-center justify-center">
                                <i data-lucide="user-cog" class="text-base text-blue-600"></i>
                            </div>
                        </div>

                        <div>
                            <h4 class="text-xl font-semibold">Routing Agen & Admin Panel</h4>
                            <p class="text-base font-normal text-gray-500 mt-2">
                                Sistem routing yang rapi dan laporan lengkap, serta pengaturan admin yang mudah disesuaikan.
                            </p>
                        </div>
                    </div>

                    <!-- Feature 4 -->
                    <div class="flex items-start gap-5 mt-8">
                        <div>
                            <div
                                class="w-12 h-12 rounded-full border border-dashed border-primary/40 bg-primary/10 flex items-center justify-center">
                                <i data-lucide="send" class="text-base text-blue-600"></i>
                            </div>
                        </div>

                        <div>
                            <h4 class="text-xl font-semibold">Blast Email & Follow-Up Otomatis</h4>
                            <p class="text-base font-normal text-gray-500 mt-2">
                                Kirim blast email dan follow-up otomatis untuk komunikasi yang lebih efisien dengan pelanggan.
                            </p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <!-- Feature End -->



    <section id="about" class="py-20">
        <div class="container">
            <div class="grid lg:grid-cols-2 items-center gap-6">
                <div class="lg:ms-5 ms-8">
                    <div>
                        <span class="text-sm text-primary uppercase font-semibold tracking-wider text-default-950">
                            Automasi Cerdas
                        </span>
                    </div>
                    <h2 class="text-3xl md:text-4xl/tight font-semibold text-black mt-4">
                        Mulai Sekarang: Setup AI dan Integrasi Channel dalam Hitungan Menit
                    </h2>
                    <p class="text-base font-normal text-muted mt-6">
                        Bangun sistem automasi percakapan berbasis AI dengan cepat. Integrasikan berbagai channel seperti WhatsApp, Instagram, dan lainnya, atur agen, dan rancang alur cerdas sesuai kebutuhan bisnismu.
                    </p>

                    <div class="grid lg:grid-cols-2 grid-cols-1 gap-8 mt-9">

                        <div>
                            <div class="flex items-center justify-start">
                                <div class="items-center justify-center flex bg-green-50 rounded-full h-20 w-20 border border-dashed border-green-50">
                                    <i data-lucide="link" class="h-8 w-8 text-black"></i>
                                </div>
                            </div>
                            <h1 class="text-xl font-semibold pt-6">1. Integrasi Channel</h1>
                            <p class="text-base text-gray-600 font-normal mt-2">
                                Sambungkan berbagai platform sosial media dan messaging hanya dengan beberapa klik.
                            </p>
                        </div>

                        <div>
                            <div class="flex items-center justify-start">
                                <div class="items-center justify-center flex bg-blue-50 rounded-full h-20 w-20 border border-dashed border-blue-50">
                                    <i data-lucide="users" class="h-8 w-8 text-black"></i>
                                </div>
                            </div>
                            <h1 class="text-xl font-semibold pt-6">2. Atur Agen</h1>
                            <p class="text-base text-gray-600 font-normal mt-2">
                                Kelola agen dan distribusikan percakapan sesuai jam kerja dan keahlian mereka.
                            </p>
                        </div>

                        <div>
                            <div class="flex items-center justify-start">
                                <div class="items-center justify-center flex bg-yellow-50 rounded-full h-20 w-20 border border-dashed border-yellow-50">
                                    <i data-lucide="brain-circuit" class="h-8 w-8 text-black"></i>
                                </div>
                            </div>
                            <h1 class="text-xl font-semibold pt-6">3. Pilih Metode AI</h1>
                            <p class="text-base text-gray-600 font-normal mt-2">
                                Gunakan 4 metode pelatihan AI: FAQ, dokumen, percakapan, atau kombinasi multi-sumber.
                            </p>
                        </div>

                        <div>
                            <div class="flex items-center justify-start">
                                <div class="items-center justify-center flex bg-purple-50 rounded-full h-20 w-20 border border-dashed border-purple-50">
                                    <i data-lucide="workflow" class="h-8 w-8 text-black"></i>
                                </div>
                            </div>
                            <h1 class="text-xl font-semibold pt-6">4. Jalankan Otomasi</h1>
                            <p class="text-base text-gray-600 font-normal mt-2">
                                Rancang alur interaksi menggunakan builder visual dan biarkan AI bekerja untukmu.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="flex items-center">
                    <img loading="lazy" src="/landing/images/flow.png" class="h-[600px] rounded-xl mx-auto shadow-lg" alt="AI Flow Diagram">
                </div>
            </div>
        </div>
    </section>

    <!-- About End -->

    <!-- Pricing Start -->
    <section id="pricing" class="py-20">
        <div class="container">
            <div class="max-w-2xl mx-auto text-center">
                <div>
                    <span class="text-sm text-primary uppercase font-semibold tracking-wider text-default-950">Pricing</span>
                </div>
                <h2 class="text-3xl md:text-4xl/tight font-semibold text-black mt-4">Get the power of the professional services with the simple price</h2>
            </div>

            <div class="grid grid-cols-1 mt-8">
                <div class="flex justify-center">
                    <div id="toggle-count" class="p-1 inline-block border border-gray-200 rounded-lg">

                    </div>
                </div>



                <div id="StarterContent">
                    <div class="mt-14" id="start-month" role="tabpanel" aria-labelledby="start-month-tab">
                        <div class="grid lg:grid-cols-3 grid-cols-1 gap-10">

                            <!-- Paket Bulanan -->
                            <div class="flex flex-col shadow-2xl rounded-xl bg-white overflow-hidden">
                                <div class="text-center pt-10">
                                    <img loading="lazy" src="/landing/images/vector/vector-1.png" class="h-28 w-28 mx-auto" alt="email">
                                    <h5 class="text-2xl font-semibold text-black">Bulanan</h5>
                                    <h2 class="text-5xl mt-5 mb-1 items-center align-middle">
                                        <sup class="text-3xl align-middle">Rp</sup>
                                        133.380
                                    </h2>
                                    <span class="text-base font-medium text-muted">30 Hari</span>
                                </div>
                                <div class="px-5 py-5 mx-auto">
                                    <ul class="text-center">
                                        <li class="py-2">✅ Unlimited Agen</li>
                                        <li class="py-2">✅ Unlimited Admin</li>
                                        <li class="py-2">✅ Bebas atur tim tanpa batasan</li>
                                        <li class="py-2">✅ Cocok untuk tim kecil maupun besar</li>
                                        <li class="py-2">✅ Support integrasi Messenger (Instagram & Facebook)<li>
                                        <li class="py-2">✅ Support integrasi WhatsApp Official -  Langganan Api Resmi Terpisah</li>
                                        <li class="py-2">✅ Support integrasi Telegram</li>
                                        <li class="py-2">✅ Support integrasi WhatsApp Unofficial Melalui (GatewayIntegrasiChat) - Langganan Terpisah</li>
                                        <li class="py-2">✅ Support integrasi Open AI - Langganan Terpisah</li>
                                    </ul>
                                </div>
                                <div class="flex justify-center px-10 pb-10">
                                    <a href="https://integrasichat.com/products" class="py-2 px-6 inline-flex rounded-md text-base items-center justify-center border border-primary text-white bg-primary hover:bg-primaryDark transition-all duration-500 font-medium w-full">Langganan Bulanan / 30 Hari</a>
                                </div>
                            </div>

                            <!-- Paket 6 Bulan -->
                            <div class="flex flex-col shadow-2xl rounded-xl bg-white overflow-hidden">
                                <div class="text-center pt-10">
                                    <img loading="lazy" src="/landing/images/vector/vector-2.png" class="h-28 w-28 mx-auto" alt="vector-2">
                                    <h5 class="text-2xl font-semibold text-black">6 Bulan</h5>
                                    <h2 class="text-5xl mt-5 mb-1 items-center align-middle">
                                        <sup class="text-3xl align-middle">Rp</sup>
                                        786.942
                                   </h2>
                                    <span class="text-base font-medium text-muted">180 Hari</span>
                                </div>
                                <div class="px-5 py-5 mx-auto">
                                    <ul class="text-center">
                                        <li class="py-2">✅ Unlimited Agen</li>
                                        <li class="py-2">✅ Unlimited Admin</li>
                                        <li class="py-2">✅ Bebas atur tim tanpa batasan</li>
                                        <li class="py-2">✅ Cocok untuk tim kecil maupun besar</li>
                                        <li class="py-2">✅ Support integrasi Messenger (Instagram & Facebook)<li>
                                        <li class="py-2">✅ Support integrasi WhatsApp Official -  Langganan Api Resmi Terpisah</li>
                                        <li class="py-2">✅ Support integrasi Telegram</li>
                                        <li class="py-2">✅ Support integrasi WhatsApp Unofficial Melalui (GatewayIntegrasiChat) - Langganan Terpisah</li>
                                        <li class="py-2">✅ Support integrasi Open AI - Langganan Terpisah</li>
                                    </ul>
                                </div>
                                <div class="flex justify-center px-10 pb-10">
                                    <a href="https://integrasichat.com/products" class="py-2 px-6 inline-flex rounded-md text-base items-center justify-center border border-primary text-white bg-primary hover:bg-primaryDark transition-all duration-500 font-medium w-full">Langganan 6 Bulan (180 Hari)</a>
                                </div>
                            </div>

                            <!-- Paket Tahunan -->
                            <div class="flex flex-col shadow-2xl rounded-xl bg-white overflow-hidden">
                                <div class="text-center pt-10">
                                    <img loading="lazy" src="/landing/images/vector/vector-3.png" class="h-28 w-28 mx-auto" alt="vector-3">
                                    <h5 class="text-2xl font-semibold text-black">12 Bulan</h5>
                                    <h2 class="text-5xl mt-5 mb-1 items-center align-middle">
                                        <sup class="text-3xl align-middle">Rp</sup>
                                        1.482.519
                                    </h2>
                                    <span class="text-base font-medium text-muted">360 Hari</span>
                                </div>
                                <div class="px-5 py-5 mx-auto">
                                    <ul class="text-center">
                                        <li class="py-2">✅ Unlimited Agen</li>
                                        <li class="py-2">✅ Unlimited Admin</li>
                                        <li class="py-2">✅ Bebas atur tim tanpa batasan</li>
                                        <li class="py-2">✅ Cocok untuk tim kecil maupun besar</li>
                                        <li class="py-2">✅ Support integrasi Messenger (Instagram & Facebook)<li>
                                        <li class="py-2">✅ Support integrasi WhatsApp Official -  Langganan Api Resmi Terpisah</li>
                                        <li class="py-2">✅ Support integrasi Telegram</li>
                                        <li class="py-2">✅ Support integrasi WhatsApp Unofficial Melalui (GatewayIntegrasiChat) - Langganan Terpisah</li>
                                        <li class="py-2">✅ Support integrasi Open AI - Langganan Terpisah</li>
                                    </ul>
                                </div>
                                <div class="flex justify-center px-10 pb-10">
                                    <a href="https://integrasichat.com/products" class="py-2 px-6 inline-flex rounded-md text-base items-center justify-center border border-primary text-white bg-primary hover:bg-primaryDark transition-all duration-500 font-medium w-full">Langganan Tahunan (360 Hari)</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- Pricing End-->

    <!-- Faqs Start -->
    <section id="FAQs" class="py-20 bg-gray-50">
        <div class="container">
            <div class="">
                <div class="text-center max-w-xl mx-auto">
                    <div>
                        <span class="text-sm text-primary uppercase font-medium tracking-wider text-default-950 mb-6">FAQs</span>
                    </div>
                    <h2 class="text-3xl md:text-4xl/tight font-semibold mt-4">Frequently Asked Questions</h2>
                </div>

                <div id="accordion-collapse" data-accordion="collapse" class="md:gap-[30px] mt-14 bg-white rounded-xl">
                    <div class="hs-accordion-group divide-y divide-gray-200">

                        <!-- FAQ 1 -->
                        <div class="relative overflow-hidden">
                            <h2 class="text-base font-semibold" id="accordion-collapse-heading-1">
                                <button type="button"
                                    class="flex justify-between items-center px-5 py-4 w-full font-semibold text-lg text-start"
                                    data-accordion-target="#accordion-collapse-body-1" aria-expanded="true"
                                    aria-controls="accordion-collapse-body-1">
                                    <span>Apakah Facebook, Instagram, Telegram, dan WhatsApp sudah termasuk?</span>
                                    <svg data-accordion-icon class="size-4 rotate-180 shrink-0" fill="currentColor"
                                        viewBox="0 0 20 20">
                                        <path fill-rule="evenodd"
                                            d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                            clip-rule="evenodd"></path>
                                    </svg>
                                </button>
                            </h2>
                            <div id="accordion-collapse-body-1" class="hidden" aria-labelledby="accordion-collapse-heading-1">
                                <div class="px-5 pb-5">
                                    <p class="text-muted text-base font-normal">
                                        Ya, integrasi dengan Facebook, Instagram, dan Telegram sudah tersedia dan bisa langsung dikaitkan sesuai panduan. Untuk WhatsApp, saat ini hanya mendukung versi *Unofficial* dan memerlukan langganan terpisah melalui penyedia layanan pihak ketiga.
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- FAQ 2 -->
                        <div class="relative overflow-hidden">
                            <h2 class="text-base font-semibold" id="accordion-collapse-heading-2">
                                <button type="button"
                                    class="flex justify-between items-center px-5 py-4 w-full font-semibold text-lg text-start"
                                    data-accordion-target="#accordion-collapse-body-2" aria-expanded="false"
                                    aria-controls="accordion-collapse-body-2">
                                    <span>Apakah AI sudah tersedia langsung di dalam sistem?</span>
                                    <svg data-accordion-icon class="size-4 shrink-0" fill="currentColor"
                                        viewBox="0 0 20 20">
                                        <path fill-rule="evenodd"
                                            d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                            clip-rule="evenodd"></path>
                                    </svg>
                                </button>
                            </h2>
                            <div id="accordion-collapse-body-2" class="hidden" aria-labelledby="accordion-collapse-heading-2">
                                <div class="px-5 pb-5">
                                    <p class="text-muted text-base font-normal">
                                        Sistem mendukung integrasi AI menggunakan API dari OpenAI. Anda hanya perlu menyiapkan API key sendiri agar fitur AI bisa digunakan untuk agen virtual Anda.
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- FAQ 3 -->
                        <div class="relative overflow-hidden">
                            <h2 class="text-base font-semibold" id="accordion-collapse-heading-3">
                                <button type="button"
                                    class="flex justify-between items-center px-5 py-4 w-full font-semibold text-lg text-start"
                                    data-accordion-target="#accordion-collapse-body-3" aria-expanded="false"
                                    aria-controls="accordion-collapse-body-3">
                                    <span>Bisakah menggunakan domain sendiri?</span>
                                    <svg data-accordion-icon class="size-4 shrink-0" fill="currentColor"
                                        viewBox="0 0 20 20">
                                        <path fill-rule="evenodd"
                                            d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                            clip-rule="evenodd"></path>
                                    </svg>
                                </button>
                            </h2>
                            <div id="accordion-collapse-body-3" class="hidden" aria-labelledby="accordion-collapse-heading-3">
                                <div class="px-5 pb-5">
                                    <p class="text-muted text-base font-normal">
                                        Tentu. Anda bisa menggunakan domain Anda sendiri dengan mengarahkan DNS ke sistem kami sesuai instruksi yang tersedia.
                                    </p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Faqs End -->





    <?php echo $__env->make('landing.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('landing.scroll-to-top', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('landing.script-file', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!-- Back to top -->

    <!-- Back to top -->

    <script src="https://cs.integrasichat.com/js/min/jquery.min.js"></script>
    <script id="sbinit" src="https://cs.integrasichat.com/js/main.js"></script>

</body>

</html>
<?php /**PATH /www/wwwroot/integrasichat.com/resources/views/landing.blade.php ENDPATH**/ ?>