<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8" />
    <title> <?php echo $__env->yieldContent('title'); ?> | <?php echo e(config('app.name')); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="<?php echo e(URL::asset('images/favicon.ico')); ?>">

    <?php echo $__env->make('layouts.head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>

<?php echo $__env->yieldContent('body'); ?>
<?php echo $__env->yieldSection(); ?>

<body data-layout="horizontal" data-topbar="dark">
    <!-- Begin page -->
    <div class="container-fluid">
        <div id="layout-wrapper">
            <?php echo $__env->make('layouts.hor-menu', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php echo $__env->make('layouts.sidebar-user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <!-- ============================================================== -->
            <!-- Start right Content here -->
            <!-- ============================================================== -->
            <div class="main-content">
                <div class="page-content">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
                <?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
            <!-- ============================================================== -->
            <!-- End Right content here -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->
    </div>
    <!-- Right Sidebar -->
    <?php echo $__env->make('layouts.right-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!-- END Right Sidebar -->

    <?php echo $__env->make('layouts.footer-script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</body>


<script>
    $(document).ready(function() {
        <?php if(session('flash')): ?>
        var flash = <?php echo json_encode(session('flash'), 15, 512) ?>; // Mengambil data FLASH
        swal({
            title: flash.type.charAt(0).toUpperCase() + flash.type.slice(
                1), // Mengubah huruf pertama menjadi kapital
            text: flash.message,
            type: flash.type, // 'success', 'error', 'info', 'warning'
            confirmButtonText: "OK"
        });
        <?php endif; ?>
    });
</script>

</html>
<?php /**PATH /www/wwwroot/integrasichat.com/resources/views/layouts/master-layouts.blade.php ENDPATH**/ ?>