<?php $__env->startSection('title'); ?>
Dashboard
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <?php $__env->startComponent('common-components.breadcrumb'); ?>
    <?php $__env->slot('title'); ?>
    Dashboard
    <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>



    <div class="row">
        <!-- Statistik Section -->
        <div class="col-lg-3 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <h5 class="card-title">Total Subscription Aktif</h5>
                    <p class="display-4 text-success"><?php echo e($activeSubscriptionCount); ?></p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <h5 class="card-title">Total Subscription Tidak Aktif</h5>
                    <p class="display-4 text-warning"><?php echo e($inactiveSubscriptionCount); ?></p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <h5 class="card-title">Total Pembayaran Belum Dibayar</h5>
                    <p class="display-4 text-danger"><?php echo e($unpaidPaymentCount); ?></p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <h5 class="card-title">Total Pembayaran Sudah Dibayar</h5>
                    <p class="display-4 text-primary"><?php echo e($paidPaymentCount); ?></p>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header">
                    Grafik Total Pembayaran (Paid) per Bulan - <?php echo e(now()->year); ?>

                </div>
                <div class="card-body">
                    <canvas id="monthlyPaidChart" height="120"></canvas>
                </div>
            </div>
        </div>
    </div>



</div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<!-- Chart JS -->
<script src="<?php echo e(URL::asset('build/libs/chart.js/chart.umd.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/js/pages/chartjs.init.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/js/app.js')); ?>"></script>
<script>
    const ctx = document.getElementById('monthlyPaidChart').getContext('2d');

    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: [
                'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'
            ],
            datasets: [{
                label: 'Total Paid',
                data: <?php echo json_encode($paidData, 15, 512) ?>,
                backgroundColor: '#007bff'
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return 'Rp ' + value.toLocaleString();
                        }
                    }
                }
            },
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'Rp ' + context.raw.toLocaleString();
                        }
                    }
                }
            }
        }
    });
</script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/integrasichat.com/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>