<?php $__env->startSection('title'); ?>
<?php echo e(__('Product')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startComponent('common-components.breadcrumb'); ?>
<?php $__env->slot('title'); ?> <?php echo e(__('Product')); ?> <?php $__env->endSlot(); ?>
<?php $__env->slot('title_li'); ?> <?php echo e($product->name); ?> <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<div class="row">
    <div class="col-lg-4 col-md-6">
        <div class="card">
            <div class="card-body">
                <div id="thumbnail-3" class="carousel slide carousel-fade" data-bs-ride="carousel">
                    <ol class="carousel-indicators">
                        <li data-bs-target="#thumbnail-3" data-bs-slide-to="0" class="active"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <a class="image-popup" href="#">
                                <img src="<?php echo e($product->image); ?>" alt="product-img"
                                    class="rounded w-100" style="object-fit: cover; max-height: 300px;">
                            </a>
                        </div>
                    </div>
                </div>
                <h5 class="my-3"><?php echo e($product->name); ?></h5>
                <div class="text-muted"><?php echo $product->description; ?></div>

                <div class="d-flex justify-content-between align-items-center border-top pt-3 mt-3">
                    <div>
                        <small class="text-muted"><?php echo e(__('Package')); ?></small>
                        <h5 class="m-0"><?php echo e($package->title); ?></h5>
                    </div>
                    <div>
                        <small class="text-muted"><?php echo e(__('Cost')); ?></small>
                        <h5 class="m-0">Rp <?php echo e(number_format($package->price, 0, ',', '.')); ?></h5>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col">
        <form action="<?php echo e(route('order.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
            <input type="hidden" name="package_id" value="<?php echo e($package->id); ?>">

            <div class="card">
                <div class="card-body">
                    <h5 class="mb-4"><?php echo e(__('Order Now')); ?></h5>

                    <?php if (! (Auth::check())): ?>
                    <div class="alert alert-warning" role="alert">
                        <ul class="mb-0">
                            <li><?php echo e(__('Password will be used to log in to the dashboard')); ?></li>
                            <li><?php echo e(__('Make sure email and WhatsApp are active...')); ?></li>
                        </ul>
                    </div>

                    <div class="mb-3">
                        <label for="name" class="form-label"><?php echo e(__('Name')); ?></label>
                        <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            id="name" name="name" value="<?php echo e(old('name')); ?>">
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="email" class="form-label"><?php echo e(__('Email')); ?></label>
                        <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            id="email" name="email" value="<?php echo e(old('email')); ?>">
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="whatsapp" class="form-label"><?php echo e(__('WhatsApp')); ?></label>
                        <input type="text" class="form-control <?php $__errorArgs = ['whatsapp'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            id="whatsapp" name="whatsapp" value="<?php echo e(old('whatsapp')); ?>">
                        <?php $__errorArgs = ['whatsapp'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="password" class="form-label"><?php echo e(__('Create Password')); ?></label>
                        <input type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            id="password" name="password">
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <?php endif; ?>

                    <div class="mb-3">
                        <label class="form-label"><?php echo e(__('Choose Domain')); ?></label>

                        <?php if(in_array($product->supported_domain, ['all', 'domain'])): ?>
                        <div class="form-check">
                            <input class="form-check-input <?php $__errorArgs = ['domain_option'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                type="radio" name="domain_option" id="own_domain" value="own"
                                onchange="toggleDomainFields()" <?php echo e(old('domain_option') == 'own' ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="own_domain">
                                <?php echo e(__('Use Own Domain')); ?>

                            </label>
                        </div>
                        <?php endif; ?>

                        <?php if(in_array($product->supported_domain, ['all', 'subdomain'])): ?>
                        <div class="form-check">
                            <input class="form-check-input <?php $__errorArgs = ['domain_option'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                type="radio" name="domain_option" id="subdomain" value="sub"
                                onchange="toggleDomainFields()" <?php echo e(old('domain_option') == 'sub' ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="subdomain">
                                <?php echo e(__('Use Subdomain')); ?>

                            </label>
                        </div>
                        <?php endif; ?>

                        <?php $__errorArgs = ['domain_option'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div id="domain_field" class="mb-3">
                        <label for="domain" class="form-label domain-label"><?php echo e(__('Subdomain')); ?></label>
                        <div class="input-group">
                            <input type="text" class="form-control <?php $__errorArgs = ['domain'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                id="domain" name="domain" value="<?php echo e(old('domain')); ?>">
                            <span class="input-group-text domain-suffix">.<?php echo e(config('app.domain')); ?></span>
                            <?php $__errorArgs = ['domain'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback d-block"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <!-- Bootstrap 5 Alert Box -->
                    <div class="alert alert-info" role="alert">
                        Jika ingin menggunakan <strong>subdomain sendiri</strong>, silakan selesaikan pengaturan subdomain terlebih dahulu, lalu <strong>hubungi kami</strong> untuk mengganti ke domain Anda sendiri. Domain Anda perlu diarahkan ke <strong>nameserver (NS)</strong> kami.
                    </div>

                    <button type="submit" class="btn btn-primary w-100"><?php echo e(__('Order Now')); ?></button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    function toggleDomainFields() {
        const domainField = document.getElementById('domain_field');
        const label = document.querySelector('.domain-label');
        const suffix = document.querySelector('.domain-suffix');

        if (document.getElementById('own_domain')?.checked) {
            label.innerHTML = 'Domain';
            suffix.style.display = 'none';
        } else {
            label.innerHTML = 'Subdomain';
            suffix.style.display = 'inline';
        }
    }

    window.onload = toggleDomainFields;
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master-layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/integrasichat.com/resources/views/orders/form.blade.php ENDPATH**/ ?>