<?php $__env->startSection('title'); ?>
    <?php echo e(__('Products')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php $__env->startComponent('common-components.breadcrumb'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(__('Products')); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('title_li'); ?>
            <?php echo e(__('Product Order')); ?>

        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <div class="row">
        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card">
                    <div class="card-body p-0">
                        <img src="<?php echo e($product->image); ?>" alt="" class="img-fluid rounded-top">
                        <div class="p-3">
                            <h5 class="mt-0 mb-2"><?php echo e($product->name); ?></h5>
                            <p class="text-muted mb-3"><?php echo e(!!$product->description); ?></p>
                            <div class="d-flex justify-content-between align-items-center">
                                <?php if($product->packages->isNotEmpty()): ?>
                                    <h5 class="mb-0"><?php echo e(__('Starting from Rp')); ?>

                                        <?php echo e(number_format($product->packages->first()->price, 0, ',', '.')); ?></h5>
                                <?php else: ?>
                                    <h5 class="mb-0"><?php echo e(__('Price not available')); ?></h5>
                                <?php endif; ?>
                                <a href="<?php echo e(route('products.show', $product->slug)); ?>" class="btn btn-primary btn-sm">
                                    <?php echo e(__('Order')); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(URL::asset('libs/apexcharts/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('libs/jquery-vectormap/jquery-vectormap.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('js/pages/dashboard.init.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master-layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/integrasichat.com/resources/views/products/index.blade.php ENDPATH**/ ?>