<!-- ========== Left Sidebar Start ========== -->
<div class="vertical-menu d-lg-none">
    <div class="h-100">

        <?php if(auth()->guard()->check()): ?>
        <div class="user-wid text-center py-4">
            <div class="user-img">
                <img src="<?php echo e(asset('images/users/avatar-2.jpg')); ?>" alt=""
                    class="avatar-md mx-auto rounded-circle">
            </div>

            <div class="mt-3">
                <a href="#" class="text-body fw-medium font-size-16"><?php echo e(Auth::user()->name); ?></a>
                <p class="text-muted mt-1 mb-0 font-size-13">Admin</p>
            </div>
        </div>
        <?php endif; ?>

        <!--- Sidemenu -->
        <div id="sidebar-menu">
            <ul class="metismenu list-unstyled" id="side-menu">
                <li class="menu-title">Menu</li>

                <?php if(auth()->guard()->check()): ?>
                <li>
                    <a href="<?php echo e(route('dashboard')); ?>" class="waves-effect">
                        <i class="mdi mdi-airplay"></i>
                        <span>Dashboard</span>
                    </a>
                </li>

                <li>
                    <a href="<?php echo e(route('products.index')); ?>" class="waves-effect">
                        <i class="mdi mdi-cart-plus"></i>
                        <span>New Order</span>
                    </a>
                </li>

                <li>
                    <a href="<?php echo e(route('subscriptions.index')); ?>" class="waves-effect">
                        <i class="mdi mdi-repeat"></i>
                        <span>My Subscriptions</span>
                    </a>
                </li>

                <li>
                    <a href="<?php echo e(route('invoices.index')); ?>" class="waves-effect">
                        <i class="mdi mdi-receipt"></i>
                        <span>My Invoices</span>
                    </a>
                </li>

                <?php if(auth()->user() && auth()->user()->is_admin): ?>
                <li>
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="waves-effect">
                        <i class="mdi mdi-view-dashboard"></i>
                        <span>Admin Dashboard</span>
                    </a>
                </li>
                <?php endif; ?>
                <?php endif; ?>

            </ul>
        </div>
        <!-- Sidebar -->
    </div>
</div>
<!-- Left Sidebar End -->
<?php /**PATH /www/wwwroot/integrasichat.com/resources/views/layouts/sidebar-user.blade.php ENDPATH**/ ?>