<?php $__env->startSection('title'); ?>
<?php echo e(__('Invoice')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
<!-- DataTables -->
<link href="<?php echo e(URL::asset('build/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
<link href="<?php echo e(URL::asset('build/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />

<!-- Responsive datatable examples -->
<link href="<?php echo e(URL::asset('build/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startComponent('common-components.breadcrumb'); ?>
<?php $__env->slot('title'); ?>
<?php echo e(__('Invoice')); ?>

<?php $__env->endSlot(); ?>
<?php $__env->slot('title_li'); ?>
<?php echo e(__('Invoice List')); ?>

<?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5><?php echo e(__('Invoice List')); ?></h5>
            </div>
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('admin.invoices.export')); ?>" class="row g-2 align-items-center mb-3">
                    <div class="col-auto">
                        <label for="month" class="col-form-label">Pilih Bulan:</label>
                    </div>
                    <div class="col-auto">
                        <select name="month" id="month" class="form-select" required>
                            <?php for($m = 1; $m <= 12; $m++): ?>
                                <option value="<?php echo e($m); ?>"><?php echo e(\Carbon\Carbon::create()->month($m)->locale('id')->isoFormat('MMMM')); ?></option>
                                <?php endfor; ?>
                        </select>
                    </div>
                    <div class="col-auto">
                        <button type="submit" class="btn btn-success">Export</button>
                    </div>
                </form>


                <table id="invoices-table" class="table table-striped table-bordered datatable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(__('User')); ?></th>
                            <th><?php echo e(__('Note')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Total')); ?></th>
                            <th><?php echo e(__('Method')); ?></th>
                            <th><?php echo e(__('Invoice Date')); ?></th>
                            <th><?php echo e(__('Expired Date')); ?></th>
                            <th><?php echo e(__('Action')); ?></th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<!-- DataTables -->
<!-- Required datatable js -->
<script src="<?php echo e(URL::asset('build/libs/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<!-- Buttons examples -->
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons-bs4/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/jszip/jszip.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/pdfmake/build/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/pdfmake/build/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-buttons/js/buttons.colVis.min.js')); ?>"></script>
<!-- Responsive examples -->
<script src="<?php echo e(URL::asset('build/libs/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>

<!-- Datatable init js -->
<script src="<?php echo e(URL::asset('build/js/pages/datatables.init.js')); ?>"></script>
<script src="<?php echo e(URL::asset('build/js/app.js')); ?>"></script>
<script>
    $(document).ready(function() {
        $('#invoices-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(route('admin.invoices.index')); ?>",
            columns: [{
                    data: 'id',
                    name: 'id',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'user',
                    name: 'user'
                },
                {
                    data: 'description',
                    name: 'description'
                },
                {
                    data: 'status',
                    name: 'status',
                    orderable: false,
                    searchable: false,
                    render: function(data) {
                        if (data === 'unpaid') {
                            return '<span class="badge bg-warning text-dark">Belum Dibayar</span>';
                        } else if (data === 'paid') {
                            return '<span class="badge bg-success">Sudah Dibayar</span>';
                        } else {
                            return '<span class="badge bg-danger">Dibatalkan</span>';
                        }
                    }

                },
                {
                    data: 'amount',
                    name: 'amount',
                    render: $.fn.dataTable.render.number(',', '.', 0, 'Rp ')
                },
                {
                    data: 'payment_method',
                    name: 'payment_method',
                    orderable: false,
                    searchable: false,

                },
                {
                    data: 'created_at',
                    name: 'created_at',
                },
                {
                    data: 'expired_at',
                    name: 'expired_at'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                },
            ]
        });

        // Handle delete button click
        $(document).on('click', '.delete', function() {
            var url = $(this).data('url');
            if (confirm('Are you sure you want to delete this invoice?')) {
                $.ajax({
                    url: url,
                    type: 'DELETE',
                    success: function(result) {
                        $('datatable').DataTable().ajax.reload();
                        alert('Invoice deleted successfully.');
                    },
                    error: function(err) {
                        alert('Error deleting invoice.');
                    }
                });
            }
        });
    });

    $(document).on('click', '.mark-as-paid', function() {
        const url = $(this).attr('data-url');
        confirmAction(
            "Anda yakin?",
            "Invoice akan ditandai sebagai sudah dibayar!",
            function() {
                $.ajax({
                    url: url,
                    type: 'PUT',
                    success: function(response) {
                        $('.datatable').DataTable().ajax.reload();
                        swal({
                            title: "Success!",
                            text: "Invoice has been marked as paid.",
                            icon: "success",
                        });
                    },
                    error: function(xhr) {

                    }
                });
            },
            function() {

            }
        );
    });
    $(document).on('click', '.mark-as-paid', function() {
        const url = $(this).attr('data-url');
        confirmAction(
            "Anda yakin?",
            "Invoice akan ditandai sebagai sudah dibayar!",
            function() {
                $.ajax({
                    url: url,
                    type: 'PUT',
                    success: function(response) {
                        $('.datatable').DataTable().ajax.reload();
                        swal({
                            title: "Success!",
                            text: "Invoice has been marked as paid.",
                            icon: "success",
                        });
                    },
                    error: function(xhr) {

                    }
                });
            },
            function() {

            }
        );
    });
    $(document).on('click', '.cancel', function() {
        const url = $(this).attr('data-url');
        confirmAction(
            "Anda yakin?",
            "Invoice akan dibatalkan!",
            function() {
                $.ajax({
                    url: url,
                    type: 'DELETE',
                    success: function(response) {
                        $('.datatable').DataTable().ajax.reload();
                        swal({
                            title: "Success!",
                            text: "Invoice has been marked as cancelled.",
                            icon: "success",
                        });
                    },
                    error: function(xhr) {

                    }
                });
            },
            function() {

            }
        );
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/integrasichat.com/resources/views/admin/invoices/index.blade.php ENDPATH**/ ?>