<?php $__env->startSection('title'); ?>
    <?php echo e(__('Product')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php $__env->startComponent('common-components.breadcrumb'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(__('Product')); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('title_li'); ?>
            <?php echo e($product->name); ?>

        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <div class="row">
        <div class="col-lg-4 col-md-6">
            <div class="card">
                <div class="card-body">

                    <img src="/<?php echo e($product->image); ?>" alt="" class="img-fluid rounded-top">

                    <h5 class="my-3"><?php echo e($product->name); ?></h5>
                    
                    <div class="text-muted"><?php echo $product->description; ?></div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="row">
                <?php $__currentLoopData = $product->packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="p-2">
                                    <h5 class="font-size-16"><?php echo e($package->title); ?></h5>

                                    <div class="text-lg"> <?php echo $package->description; ?></div>
                                    <h1 class="mt-3">
                                        Rp <?php echo e(number_format($package->price, 0, ',', '.')); ?>

                                        <span class="text-muted font-size-16 fw-medium">/ <?php echo e($package->duration); ?> <?php echo e(__('Days')); ?></span>
                                    </h1>
                                    <div class="mt-3 pt-2">

                                        <?php if($package->external): ?>
                                            <a href="<?php echo e($package->external); ?>" target="_blank"
                                                class="btn btn-outline-secondary w-100"><?php echo e(__('Select')); ?></a>
                                        <?php else: ?>
                                            <a href="<?php echo e(route('order.form', ['product' => $product->slug, 'productPackage' => $package->id])); ?>"
                                                class="btn btn-outline-secondary w-100"><?php echo e(__('Select')); ?></a>
                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
    </div>

    <!-- end row -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <!-- plugin js -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master-layouts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/integrasichat.com/resources/views/products/show.blade.php ENDPATH**/ ?>