<?php

use App\Clients\AapanelApi;
use App\Http\Controllers\AccountController;
use App\Http\Controllers\AppUpdateController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\CallbackPaymentController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SynchController;
use Illuminate\Http\Client\Request;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;


Route::group(
    ['prefix' => LaravelLocalization::setLocale()],
    function () {


        Route::post('/payment/callback', [CallbackPaymentController::class, 'index'])->name('callback_pg');
        Route::post('/payment/callback/ipaymu', [CallbackPaymentController::class, 'callbackIpaymu'])->name('callback_ipaymu');

        Route::get('/', function () {
            return view('landing');
        })->name('landing');
        Route::get('/products', [ProductController::class, 'index'])->name('products.index');
        Route::get('/product/{product:slug}', [ProductController::class, 'show'])->name('products.show');

        Route::get('/order/{product:slug}/{productPackage:id}', [OrderController::class, 'form'])->name('order.form');
        Route::post('/order', [OrderController::class, 'store'])->name('order.store');

        Route::middleware('auth')->group(function () {
            Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
            Route::get('/invoices', [InvoiceController::class, 'index'])->name('invoices.index');
            Route::get('/invoice/{invoice:invoice_number}', [InvoiceController::class, 'detail'])->name('invoices.detail');
            Route::get('/invoice/{invoice:invoice_number}/payment', [InvoiceController::class, 'payment'])->name('invoices.payment');
            Route::post('/invoice/processPayment', [InvoiceController::class, 'processPayment'])->name('invoices.processPayment');

            Route::get('/subscriptions', [SubscriptionController::class, 'index'])->name('subscriptions.index');

            Route::get('/account/settings', [AccountController::class, 'settings'])->name('account.settings');
            Route::put('/account/settings', [AccountController::class, 'updateSettings'])->name('account.updateSettings');

            Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
        });

        Route::get('/login', [AuthController::class, 'loginPage'])->name('login');
        Route::post('/login', [AuthController::class, 'login'])->name('login');
    }
);

Route::get('/synchronize', [SynchController::class, 'index']);
Route::get('/synch/versions.json', [AppUpdateController::class, 'versions']);
Route::get('/synch/updates', [AppUpdateController::class, 'updates']);
Route::get('/synch/temp/{filename}', [AppUpdateController::class, 'getFile']);

Route::get('/privacy-policy', function () {
    return view('page.privacy-policy');
});

//synch app

require __DIR__ . '/admin.php';
