<?php

use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\DomainController;
use App\Http\Controllers\Admin\InvoiceController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\PaymentChannelController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\ServerController;
use App\Http\Controllers\Admin\SubscriptionController;
use App\Http\Controllers\Admin\UserController;

use Illuminate\Support\Facades\Route;

Route::group(
    ['prefix' => LaravelLocalization::setLocale()],
    function () {

        Route::middleware('auth', 'admin')->prefix('admin')->group(function () {

            Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');

            Route::get('/subscriptions', [SubscriptionController::class, 'index'])->name('admin.subscriptions.index');
            Route::get('/subscriptions/{subscription}/edit', [SubscriptionController::class, 'edit'])->name('admin.subscriptions.edit');
            Route::put('/subscriptions/{subscription}', [SubscriptionController::class, 'update'])->name('admin.subscriptions.update');
            Route::delete('/subscriptions/{subscription}', [SubscriptionController::class, 'destroy'])->name('admin.subscriptions.destroy');

            Route::get('/invoices', [InvoiceController::class, 'index'])->name('admin.invoices.index');
            Route::put('/invoices/{invoice}/mark-as-paid', [InvoiceController::class, 'markAsPaid'])->name('admin.invoices.mark-as-paid');
            Route::delete('/invoices/{invoice}/cancel', [InvoiceController::class, 'cancel'])->name('admin.invoices.cancel');
            Route::get('/admin/invoices/export', [InvoiceController::class, 'export'])->name('admin.invoices.export');


            Route::get('/products', [ProductController::class, 'index'])->name('admin.products.index');
            Route::get('/products/{product}/edit', [ProductController::class, 'edit'])->name('admin.products.edit');
            Route::get('/products/create', [ProductController::class, 'create'])->name('admin.products.create');
            Route::post('/products', [ProductController::class, 'store'])->name('admin.products.store');
            Route::put('/products/{product}', [ProductController::class, 'update'])->name('admin.products.update');

            Route::get('/', [PackageController::class, 'index'])->name('admin.packages.index');
            Route::get('/create', [PackageController::class, 'create'])->name('admin.packages.create');
            Route::post('/', [PackageController::class, 'store'])->name('admin.packages.store');
            Route::get('/{package}/edit', [PackageController::class, 'edit'])->name('admin.packages.edit');
            Route::put('/{package}', [PackageController::class, 'update'])->name('admin.packages.update');
            Route::delete('/{package}', [PackageController::class, 'destroy'])->name('admin.packages.destroy');
            Route::get('/users', [UserController::class, 'index'])->name('admin.users.index');

            //server resource
            Route::get('/servers', [ServerController::class, 'index'])->name('admin.servers.index');
            Route::get('/servers/create', [ServerController::class, 'create'])->name('admin.servers.create');
            Route::post('/servers', [ServerController::class, 'store'])->name('admin.servers.store');
            Route::get('/servers/{server}/edit', [ServerController::class, 'edit'])->name('admin.servers.edit');
            Route::put('/servers/{server}', [ServerController::class, 'update'])->name('admin.servers.update');
            Route::delete('/servers/{server}', [ServerController::class, 'destroy'])->name('admin.servers.destroy');
            Route::post('/server/test', [ServerController::class, 'checkConnection'])->name('server.test');
            Route::get('/server/{server}/detail', [ServerController::class, 'detailServer'])->name('admin.servers.detail');

            Route::get('/domains', [DomainController::class, 'index'])->name('domains.index');
            Route::delete('/domains/delete', [DomainController::class, 'delete'])->name('admin.domains.delete');

            Route::get('/payment-methods', [PaymentChannelController::class, 'index'])->name('admin.payment_methods.index');
            Route::get('/payment-methods/add', [PaymentChannelController::class, 'create'])->name('admin.payment_methods.create');
            Route::post('/payment-methods', [PaymentChannelController::class, 'store'])->name('admin.payment_methods.store');
            Route::post('/payment-methods/{paymentMethod}/toggle', [PaymentChannelController::class, 'toggle'])->name('admin.payment_methods.edit');
            Route::put('/payment-methods/{paymentMethod}/edit', [PaymentChannelController::class, 'edit'])->name('admin.payment_methods.edit');
            Route::delete('/payment-methods/{paymentMethod}/delete', [PaymentChannelController::class, 'destroy'])->name('admin.payment_methods.destroy');

            Route::delete('/users/{user}', [UserController::class, 'destroy'])->name('admin.users.destroy');
        });
    }
);
