@extends('layouts.master-layouts')

@section('title')
{{ __('My Subscriptions') }}
@endsection
@push('css')
<!-- DataTables -->
<link href="{{ URL::asset('build/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
<link href="{{ URL::asset('build/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />

<!-- Responsive datatable examples -->
<link href="{{ URL::asset('build/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
@endpush

@section('content')
@component('common-components.breadcrumb')
@slot('title')
{{ __('My Subscriptions') }}
@endslot
@slot('title_li')
@endslot
@endcomponent

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">

                <h4 class="card-title">{{ __('Subscriptions') }}</h4>
                <p class="card-title-desc">{{ __('All subscriptions related to your account will be displayed here.') }}</p>

                <table id="datatable-buttons" class="table table-bordered dt-responsive nowrap"
                    style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ __('Order Date') }}</th>
                            <th>{{ __('Domain') }}</th>
                            <th>{{ __('Product') }}</th>
                            <th>{{ __('Active Date') }}</th>
                            <th>{{ __('Due Date') }}</th>
                            <th>{{ __('Last Invoice') }}</th>
                            <th>{{ __('Status') }}</th>

                        </tr>
                    </thead>

                    <tbody>

                        @foreach ($subscriptions as $subscription)
                        <tr>
                            <td>{{ $subscription->id }}</td>
                            <td>{{ $subscription->created_at->format('d M Y') }}</td>
                            <td>{{ $subscription->domain }}<br>
                                @if ($subscription->ns)
                                <span class="text-muted">{{ __('Nameserver:') }}</span><br>
                                @foreach (explode(',', $subscription->ns) as $ns)
                                <span class="badge badge-light">{{ $ns }}</span>
                                @endforeach
                                @endif
                            </td>
                            <td>{{ $subscription->product }}</td>
                            <td>{{ $subscription->start_date ? \Carbon\Carbon::parse($subscription->start_date)->format('d M Y') : '-' }}</td>
                            <td>{{ $subscription->due_date ? \Carbon\Carbon::parse($subscription->due_date)->format('d M Y') : '-' }}</td>

                            <td>
                                <a href="{{ route('invoices.detail', $subscription->lastPayment->invoice_number) }}"
                                    class="text-primary">{{ $subscription->lastPayment->invoice_number }}</a>
                            </td>
                            <td>
                                @if ($subscription->status == 'waiting')
                                <span class="badge bg-warning">{{ __('Waiting') }}</span>
                                @elseif ($subscription->status == 'active')
                                <span class="badge bg-success">{{ __('Active') }}</span>
                                @elseif ($subscription->status == 'processing')
                                <span class="badge bg-info">{{ __('Processing') }}</span>
                                @else
                                <span class="badge bg-danger">{{ __('Suspended/Inactive') }}</span>
                                @endif
                            </td>

                        </tr>
                        @endforeach
                    </tbody>
                </table>

            </div>
        </div>
    </div>
</div>
@endsection


@push('script')
<!-- Required datatable js -->
<script src="{{ URL::asset('build/libs/datatables.net/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<!-- Buttons examples -->
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons-bs4/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/jszip/jszip.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/pdfmake/build/pdfmake.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/pdfmake/build/vfs_fonts.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.html5.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.print.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.colVis.min.js') }}"></script>
<!-- Responsive examples -->
<script src="{{ URL::asset('build/libs/datatables.net-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js') }}"></script>

<!-- Datatable init js -->
<script src="{{ URL::asset('build/js/pages/datatables.init.js') }}"></script>
@endpush
