@extends('layouts.master-layouts')

@section('title')
    {{ __('Product') }}
@endsection

@section('content')
    @component('common-components.breadcrumb')
        @slot('title')
            {{ __('Product') }}
        @endslot
        @slot('title_li')
            {{ $product->name }}
        @endslot
    @endcomponent

    <div class="row">
        <div class="col-lg-4 col-md-6">
            <div class="card">
                <div class="card-body">

                    <img src="/{{ $product->image }}" alt="" class="img-fluid rounded-top">

                    <h5 class="my-3">{{ $product->name }}</h5>
                    {{-- show description as html --}}
                    <div class="text-muted">{!! $product->description !!}</div>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="row">
                @foreach ($product->packages as $package)
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="p-2">
                                    <h5 class="font-size-16">{{ $package->title }}</h5>

                                    <div class="text-lg"> {!! $package->description !!}</div>
                                    <h1 class="mt-3">
                                        Rp {{ number_format($package->price, 0, ',', '.') }}
                                        <span class="text-muted font-size-16 fw-medium">/ {{ $package->duration }} {{ __('Days') }}</span>
                                    </h1>
                                    <div class="mt-3 pt-2">

                                        @if ($package->external)
                                            <a href="{{ $package->external }}" target="_blank"
                                                class="btn btn-outline-secondary w-100">{{ __('Select') }}</a>
                                        @else
                                            <a href="{{ route('order.form', ['product' => $product->slug, 'productPackage' => $package->id]) }}"
                                                class="btn btn-outline-secondary w-100">{{ __('Select') }}</a>
                                        @endif

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </div>

    <!-- end row -->
@endsection

@section('script')
    <!-- plugin js -->
@endsection
