@extends('layouts.master-layouts')

@section('title')
    {{ __('Products') }}
@endsection

@section('content')
    @component('common-components.breadcrumb')
        @slot('title')
            {{ __('Products') }}
        @endslot
        @slot('title_li')
            {{ __('Product Order') }}
        @endslot
    @endcomponent

    <div class="row">
        @foreach ($products as $product)
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card">
                    <div class="card-body p-0">
                        <img src="{{ $product->image }}" alt="" class="img-fluid rounded-top">
                        <div class="p-3">
                            <h5 class="mt-0 mb-2">{{ $product->name }}</h5>
                            <p class="text-muted mb-3">{{ !!$product->description }}</p>
                            <div class="d-flex justify-content-between align-items-center">
                                @if ($product->packages->isNotEmpty())
                                    <h5 class="mb-0">{{ __('Starting from Rp') }}
                                        {{ number_format($product->packages->first()->price, 0, ',', '.') }}</h5>
                                @else
                                    <h5 class="mb-0">{{ __('Price not available') }}</h5>
                                @endif
                                <a href="{{ route('products.show', $product->slug) }}" class="btn btn-primary btn-sm">
                                    {{ __('Order') }}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@endsection

@section('script')
    <script src="{{ URL::asset('libs/apexcharts/apexcharts.min.js') }}"></script>
    <script src="{{ URL::asset('libs/jquery-vectormap/jquery-vectormap.min.js') }}"></script>
    <script src="{{ URL::asset('js/pages/dashboard.init.js') }}"></script>
@endsection
