@extends('layouts.master-layouts')

@section('title')
{{ __('Product') }}
@endsection

@section('content')
@component('common-components.breadcrumb')
@slot('title') {{ __('Product') }} @endslot
@slot('title_li') {{ $product->name }} @endslot
@endcomponent

<div class="row">
    <div class="col-lg-4 col-md-6">
        <div class="card">
            <div class="card-body">
                <div id="thumbnail-3" class="carousel slide carousel-fade" data-bs-ride="carousel">
                    <ol class="carousel-indicators">
                        <li data-bs-target="#thumbnail-3" data-bs-slide-to="0" class="active"></li>
                    </ol>
                    <div class="carousel-inner">
                        <div class="carousel-item active">
                            <a class="image-popup" href="#">
                                <img src="{{ $product->image }}" alt="product-img"
                                    class="rounded w-100" style="object-fit: cover; max-height: 300px;">
                            </a>
                        </div>
                    </div>
                </div>
                <h5 class="my-3">{{ $product->name }}</h5>
                <div class="text-muted">{!! $product->description !!}</div>

                <div class="d-flex justify-content-between align-items-center border-top pt-3 mt-3">
                    <div>
                        <small class="text-muted">{{ __('Package') }}</small>
                        <h5 class="m-0">{{ $package->title }}</h5>
                    </div>
                    <div>
                        <small class="text-muted">{{ __('Cost') }}</small>
                        <h5 class="m-0">Rp {{ number_format($package->price, 0, ',', '.') }}</h5>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col">
        <form action="{{ route('order.store') }}" method="POST">
            @csrf
            <input type="hidden" name="product_id" value="{{ $product->id }}">
            <input type="hidden" name="package_id" value="{{ $package->id }}">

            <div class="card">
                <div class="card-body">
                    <h5 class="mb-4">{{ __('Order Now') }}</h5>

                    @unless(Auth::check())
                    <div class="alert alert-warning" role="alert">
                        <ul class="mb-0">
                            <li>{{ __('Password will be used to log in to the dashboard') }}</li>
                            <li>{{ __('Make sure email and WhatsApp are active...') }}</li>
                        </ul>
                    </div>

                    <div class="mb-3">
                        <label for="name" class="form-label">{{ __('Name') }}</label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror"
                            id="name" name="name" value="{{ old('name') }}">
                        @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="email" class="form-label">{{ __('Email') }}</label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror"
                            id="email" name="email" value="{{ old('email') }}">
                        @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="whatsapp" class="form-label">{{ __('WhatsApp') }}</label>
                        <input type="text" class="form-control @error('whatsapp') is-invalid @enderror"
                            id="whatsapp" name="whatsapp" value="{{ old('whatsapp') }}">
                        @error('whatsapp') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <div class="mb-3">
                        <label for="password" class="form-label">{{ __('Create Password') }}</label>
                        <input type="password" class="form-control @error('password') is-invalid @enderror"
                            id="password" name="password">
                        @error('password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                    @endunless

                    <div class="mb-3">
                        <label class="form-label">{{ __('Choose Domain') }}</label>

                        @if (in_array($product->supported_domain, ['all', 'domain']))
                        <div class="form-check">
                            <input class="form-check-input @error('domain_option') is-invalid @enderror"
                                type="radio" name="domain_option" id="own_domain" value="own"
                                onchange="toggleDomainFields()" {{ old('domain_option') == 'own' ? 'checked' : '' }}>
                            <label class="form-check-label" for="own_domain">
                                {{ __('Use Own Domain') }}
                            </label>
                        </div>
                        @endif

                        @if (in_array($product->supported_domain, ['all', 'subdomain']))
                        <div class="form-check">
                            <input class="form-check-input @error('domain_option') is-invalid @enderror"
                                type="radio" name="domain_option" id="subdomain" value="sub"
                                onchange="toggleDomainFields()" {{ old('domain_option') == 'sub' ? 'checked' : '' }}>
                            <label class="form-check-label" for="subdomain">
                                {{ __('Use Subdomain') }}
                            </label>
                        </div>
                        @endif

                        @error('domain_option') <div class="text-danger small">{{ $message }}</div> @enderror
                    </div>

                    <div id="domain_field" class="mb-3">
                        <label for="domain" class="form-label domain-label">{{ __('Subdomain') }}</label>
                        <div class="input-group">
                            <input type="text" class="form-control @error('domain') is-invalid @enderror"
                                id="domain" name="domain" value="{{ old('domain') }}">
                            <span class="input-group-text domain-suffix">.{{ config('app.domain') }}</span>
                            @error('domain') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                        </div>
                    </div>
                    <!-- Bootstrap 5 Alert Box -->
                    <div class="alert alert-info" role="alert">
                        Jika ingin menggunakan <strong>subdomain sendiri</strong>, silakan selesaikan pengaturan subdomain terlebih dahulu, lalu <strong>hubungi kami</strong> untuk mengganti ke domain Anda sendiri. Domain Anda perlu diarahkan ke <strong>nameserver (NS)</strong> kami.
                    </div>

                    <button type="submit" class="btn btn-primary w-100">{{ __('Order Now') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('script')
<script>
    function toggleDomainFields() {
        const domainField = document.getElementById('domain_field');
        const label = document.querySelector('.domain-label');
        const suffix = document.querySelector('.domain-suffix');

        if (document.getElementById('own_domain')?.checked) {
            label.innerHTML = 'Domain';
            suffix.style.display = 'none';
        } else {
            label.innerHTML = 'Subdomain';
            suffix.style.display = 'inline';
        }
    }

    window.onload = toggleDomainFields;
</script>
@endsection
