<!-- ========== Left Sidebar Start ========== -->
<div class="vertical-menu d-lg-none">
    <div class="h-100">

        @auth
        <div class="user-wid text-center py-4">
            <div class="user-img">
                <img src="{{ asset('images/users/avatar-2.jpg') }}" alt=""
                    class="avatar-md mx-auto rounded-circle">
            </div>

            <div class="mt-3">
                <a href="#" class="text-body fw-medium font-size-16">{{ Auth::user()->name }}</a>
                <p class="text-muted mt-1 mb-0 font-size-13">Admin</p>
            </div>
        </div>
        @endauth

        <!--- Sidemenu -->
        <div id="sidebar-menu">
            <ul class="metismenu list-unstyled" id="side-menu">
                <li class="menu-title">Menu</li>

                @auth
                <li>
                    <a href="{{ route('dashboard') }}" class="waves-effect">
                        <i class="mdi mdi-airplay"></i>
                        <span>Dashboard</span>
                    </a>
                </li>

                <li>
                    <a href="{{ route('products.index') }}" class="waves-effect">
                        <i class="mdi mdi-cart-plus"></i>
                        <span>New Order</span>
                    </a>
                </li>

                <li>
                    <a href="{{ route('subscriptions.index') }}" class="waves-effect">
                        <i class="mdi mdi-repeat"></i>
                        <span>My Subscriptions</span>
                    </a>
                </li>

                <li>
                    <a href="{{ route('invoices.index') }}" class="waves-effect">
                        <i class="mdi mdi-receipt"></i>
                        <span>My Invoices</span>
                    </a>
                </li>

                @if (auth()->user() && auth()->user()->is_admin)
                <li>
                    <a href="{{ route('admin.dashboard') }}" class="waves-effect">
                        <i class="mdi mdi-view-dashboard"></i>
                        <span>Admin Dashboard</span>
                    </a>
                </li>
                @endif
                @endauth

            </ul>
        </div>
        <!-- Sidebar -->
    </div>
</div>
<!-- Left Sidebar End -->
