<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8" />
    <title>Live Chat OmniChannel - {{ config('app.name') }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description"
        content="{{ config('app.name') }} adalah solusi aplikasi OmniChannel untuk layanan pelanggan dengan dukungan AI, menyediakan fitur live chat yang efisien dan mudah diintegrasikan." />
    <meta name="keywords"
        content="OmniChannel, Customer Service, Live Chat, AI, Aplikasi Layanan Pelanggan, Chatbot, AI Customer Support, Integrasi Chat, BlasChat, WhatsApp API" />
    <meta name="author" content="{{ config('app.name') }}" />
    <meta property="og:type" content="website" />
    <meta property="og:url" content="{{ url('/') }}" />
    <meta property="og:title"
        content="{{ config('app.name') }} - Aplikasi OmniChannel Customer Service dan Live Chat Berbasis AI" />
    <meta property="og:description"
        content="{{ config('app.name') }} adalah aplikasi OmniChannel customer service dengan teknologi AI, memberikan solusi live chat yang terintegrasi dan mendukung berbagai platform." />
    <meta property="og:image" content="{{ asset('images/logo-sm.png') }}" />
    {{-- favicon --}}
    <link rel="shortcut icon" href="{{ asset('images/favicon.ico') }}" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title"
        content="{{ config('app.name') }} - Aplikasi OmniChannel Customer Service dan Live Chat Berbasis AI" />
    <meta name="twitter:description"
        content="{{ config('app.name') }} adalah aplikasi OmniChannel customer service dengan fitur live chat berbasis AI untuk mendukung layanan pelanggan lebih cepat dan efektif." />

    <!-- favicon -->
    <link rel="shortcut icon" href="{{ asset('images/favicon.ico') }}" />

    <!-- CSS -->
    <link href="{{ asset('landing/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('landing/css/materialdesignicons.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('landing/css/style.min.css') }}" rel="stylesheet" type="text/css" />

    <!-- Additional SEO Tags -->
    <link rel="canonical" href="{{ url('/') }}" />
</head>

<body>

    <!-- light-dark mode -->

    {{-- <a href="javascript: void(0);" id="light-dark-mode" class="text-white mode-btn rounded-end">
        <i class="mdi mdi-sun-compass bx-spin mode-light"></i>
        <i class="mdi mdi-moon-waning-crescent mode-dark"></i>
    </a> --}}

    <!-- Loader -->
    {{-- <div id="preloader">
        <div id="status">
            <div class="spinner"></div>
        </div>
    </div> --}}

    <!--Navbar Start-->

    {{-- <nav class="sticky navbar navbar-expand-lg fixed-top navbar-custom sticky-dark" id="navbar">
        <div class="container">
            <!-- LOGO -->
            <a class="navbar-brand logo" href="layout-one-1.html">
                <img src="{{ asset('images/logo-dark.png') }}" alt="" class="logo-dark" height="45" />
                <img src="{{ asset('images/logo-light.png') }}" alt="" class="logo-light" height="45" />
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse"
                aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
                <i class="mdi mdi-menu"></i>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <ul class="mx-auto navbar-nav navbar-center" id="navbar-navlist">
                    <li class="nav-item">
                        <a data-scroll href="#home" class="nav-link">Home</a>
                    </li>
                    <li class="nav-item">
                        <a data-scroll href="#features" class="nav-link">Fitur</a>
                    </li>
                    <li class="nav-item">
                        <a data-scroll href="#pricing" class="nav-link">Harga</a>
                    </li>


                </ul>

            </div>
        </div>
    </nav> --}}
    <!-- Navbar End -->

    <!-- Hero Start -->
    <section class="" style="background-image: url({{ asset('landing/images/hero-1-bg-img.png') }})"
        id="home">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-lg-6">
                    <h1 class="mb-4 hero-1-title fw-bold text-shadow">
                        {{ __('Mudahkan Customer menghubungi anda agar bisnis anda semakin professional!') }}
                    </h1>
                    <div class="mb-5 w-75 mb-lg-0">
                        <p class="pb-5 mb-5 text-muted font-size-17">
                            {{ __('Banyak pilihan integrasi seperti AI, dialog flow,google search , juga mendukung omnichannel sehingga anda dapat kelola semua pesan social media dalam 1 dashboard') }}
                        </p>
                        <p><span class="font-size-20 me-2">🥳️</span></p>

                    </div>
                </div>
                <div class="col-lg-6 col-md-10">
                    <div class="mt-5 mt-lg-0">
                        <img style="max-width: 80%; max-height:80%" src="{{ asset('landing/images/live-chat.gif') }}"
                            alt="" class="mx-auto img-fluid d-block">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Hero End -->
    <!-- Features Start -->


    <section id="features" class="section feather-bg-img" style="background-image: url(images/features-bg-img-1.png)">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8 align-self-center">
                    <p class="mb-2 font-weight-medium text-uppercase">
                        <i class="align-middle mdi mdi-chart-bubble h2 text-primary me-1"></i>
                        {{ __('Fitur Unggulan') }}
                    </p>
                    <h3 class="mb-4 font-weight-semibold line-height-1_4">
                        {{ __('Omnichannel , anda dapat mengelola banyak pesan platform dalam satu') }} <b>{{ __('Dashboard') }}</b>
                    </h3>
                    <p class="mb-4 text-muted font-size-15">
                        {{ __('Tidak hanya Live Chat Website, Anda dapat integrasikan dengan telegram , facebook,instagram dan whatsapp,kemudian balas pesan dan kelola pesan melalui 1 dashboard saja') }}
                    </p>


                </div>
                <div class="col-lg-12 offset-lg-1 align-self-center">

                    <img width="120%" src="{{ asset('landing/images/l-chat.png') }}" alt=""
                        class="mx-auto img-fluid d-block">

                </div>
            </div>
        </div>
    </section>
    <!-- Why Choose Us Start -->
    <section class="section">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-4 align-self-center">
                    <div class="mb-4 mb-lg-0">
                        <div class="p-2 mb-4 rounded bg-soft-primary d-inline-block">
                            <div class="icon-xxl uim-icon-primary"><i class="uim uim-cube"></i></div>
                        </div>
                        <h3 class="">
                            {{ __('Mengapa Memilih Kami?') }}
                        </h3>
                        <p class="mb-4 text-muted">
                            {{ __('Kami menyediakan platform yang memungkinkan Anda untuk mengelola pelanggan dari berbagai sosial media dengan satu dashboard, mendukung banyak agent dan banyak pilihan integrasi.') }}
                        </p>
                        <a href="#" class="btn btn-outline-primary">
                            {{ __('Pelajari Lebih Lanjut') }}
                        </a>
                    </div>
                </div>
                <div class="col-lg-8 align-self-center">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="p-4 text-center rounded wc-box wc-box-primary mt-md-5">
                                <div class="wc-box-icon">
                                    <i class="mdi mdi-collage"></i>
                                </div>
                                <h5 class="mt-4 mb-2 fw-bold wc-title">
                                    {{ __('Unlimited live chat') }}
                                </h5>
                                <p class="mb-0 text-muted font-size-15 wc-subtitle">
                                    {{ __('Komunikasi dengan pengunjung website anda secara real-time, tanpa batasan. berupa floating chatbox yang berada di sudut website anda.') }}
                                </p>
                            </div>
                            <div class="p-4 text-center rounded wc-box wc-box-primary">
                                <div class="wc-box-icon">
                                    <i class="mdi mdi-trending-up"></i>
                                </div>
                                <h5 class="mt-4 mb-2 fw-bold wc-title">
                                    {{ __('Integrasi Pesan') }}
                                </h5>
                                <p class="mb-0 text-muted font-size-15 wc-subtitle">
                                    {{ __('Kami mendukung integrasi dengan facebook,instagram dan whatsapp unofficial , seluruh pesan masuk akan terintegrasi dalam satu dashboard. (Saat ini whatsapp hanya support melalui Boostify dan MPWA , layanan wa dibeli terpisah)') }}
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="p-4 text-center rounded wc-box wc-box-primary">
                                <div class="wc-box-icon">
                                    <i class="mdi mdi-security"></i>
                                </div>
                                <h5 class="mt-4 mb-2 fw-bold wc-title">
                                    {{ __('Integrasi AI sebagai Customer Service') }}
                                </h5>
                                <p class="mb-0 text-muted font-size-15 wc-subtitle">
                                    {{ __('Integrasikan dengan OpenAi, dialogflow,google search dan sebagainya, kemudian latih dengan data anda sendiri, sehingga anda bisa memiliki customer service berbasis AI yang efektif. terdapat beberapa metode untuk training AI.') }}
                                </p>
                            </div>
                            <div class="p-4 text-center rounded wc-box wc-box-primary">
                                <div class="wc-box-icon">
                                    <i class="mdi mdi-database-lock"></i>
                                </div>
                                <h5 class="mt-4 mb-2 fw-bold wc-title">PWA </h5>
                                <p class="mb-0 text-muted font-size-15 wc-subtitle">
                                    {{ __('Kami mendukung PWA (Progressive Web App) , sehingga anda bisa mengakses dashboard kami melalui smartphone ,tablet dan desktop dengan tampilan yang...') }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Choose Us End -->




    <!-- Features End -->

    <!-- Pricing Start -->
    <section class="section bg-light" id="pricing">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="mb-5 text-center">
                        <h3 class="mb-3 title">Harga Layanan</h3>
                        <p class="text-muted font-size-15">Pilih paket yang sesuai dengan kebutuhan Anda.</p>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="p-4 text-center rounded pricing-box">
                        <div class="my-4 pricing-icon-bg">
                            <i class="mdi mdi-clock h1"></i>
                        </div>
                        <h4 class="mb-3 title">Trial Gratis</h4>
                        <h1 class="mb-0 fw-bold"><b><sup class="h4 me-2 fw-bold">Rp</sup>0</b></h1>
                        <p class="text-muted font-weight-semibold">3 Hari</p>
                        <ul class="mb-4 list-unstyled pricing-item">
                            <li class="text-muted">1 Admin + 3 Agent</li>
                            <li class="text-muted">Semua Fitur Interaksi.Live</li>
                            <li class="text-muted">Free Update Channels and Features</li>
                        </ul>
                        <a href="{{ route('products.index') }}" class="btn btn-outline-primary pr-btn">Coba
                            Sekarang</a>
                        <p class="mt-3 text-muted"><small>*Whatsapp unofficial mpwa/boostifyhub.id dibeli terpisah<br>
                            </small></p>
                        <div class="mt-4">
                            <div class="hero-bottom-img">
                                <img src="images/pricing-bottom-bg.png" alt=""
                                    class="mx-auto img-fluid d-block">
                            </div>
                        </div>
                    </div>
                </div>
                {{-- <div class="col-lg-4">
                    <div class="p-4 text-center rounded pricing-box active">
                        <div class="my-4 pricing-icon-bg">
                            <i class="mdi mdi-currency-rupiah h1"></i>
                        </div>
                        <h4 class="mb-3 title">Tahunan</h4>
                        <h1 class="mb-0 fw-bold"><b><sup class="h4 me-2 fw-bold">Rp</sup>1.000.000</b></h1>
                        <p class="text-muted font-weight-semibold">Per-Tahun</p>
                        <ul class="mb-4 list-unstyled pricing-item">
                            <li class="text-muted">1 Admin + 2 Agent</li>
                            <li class="text-muted">Semua Fitur BalasChat</li>
                            <li class="text-muted">Free Update Channels and Features</li>
                        </ul>
                        <a href="#" class="btn btn-primary pr-btn">Beli Sekarang</a>
                        <p class="mt-3 text-muted"><small>*Whatsapp unofficial starsender/onesender dibeli terpisah<br>
                                **Tagihan WA Official API dibayar terpisah</small></p>
                        <div class="mt-4">
                            <div class="hero-bottom-img">
                                <img src="images/pricing-bottom-bg.png" alt=""
                                    class="mx-auto img-fluid d-block">
                            </div>
                        </div>
                    </div>
                </div> --}}
                <div class="col-lg-4">
                    <div class="p-4 text-center rounded pricing-box">
                        <div class="my-4 pricing-icon-bg">
                            <i class="mdi mdi-currency-rupiah h1"></i>
                        </div>
                        <h4 class="mb-3 title">Bulanan</h4>
                        <h1 class="mb-0 fw-bold"><b><sup class="h4 me-2 fw-bold">Rp</sup>100.000</b></h1>
                        <p class="text-muted font-weight-semibold">Per-Bulan</p>
                        <ul class="mb-4 list-unstyled pricing-item">
                            <li class="text-muted">1 Admin + 3 Agent</li>
                            <li class="text-muted">Semua Fitur Interaksi.Live</li>
                            <li class="text-muted">Free Update Channels and Features</li>
                        </ul>
                        <a href="{{ route('products.index') }}" class="btn btn-outline-primary pr-btn">Beli
                            Sekarang</a>
                        <p class="mt-3 text-muted"><small>*Whatsapp unofficial mpwa/boostifyhub.id dibeli terpisah<br>
                            </small></p>
                        <div class="mt-4">
                            <div class="hero-bottom-img">
                                <img src="images/pricing-bottom-bg.png" alt=""
                                    class="mx-auto img-fluid d-block">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Pricing End -->



    <!-- Footer Start -->
    <section class="footer" style="background-image: url(images/footer-bg.png)">
        <div class="container">
            <div class="text-center text-white row justify-content-center">
                <!-- <p class="text-center text-white-50">
                    Interaksi.Live by <a href="https://m-pedia.co.id" target="_blank"
                        class="text-white text-decoration-underline">M-Pedia</a>
                </p> -->
                <!-- <p>Bogor, Indonesia, Jawa Barat 16164</p> -->
                <p>
                    Halaman ini bukan merupakan bagian dari official website dari WhatsApp, Facebook, Instagram,
                    Telegram, Google, OpenAi, Dialogflow, dan sebagainya.
                </p>
                <p>Email: <a href="mailto:admin@m-pedia.co.id" class="text-white">admin@m-pedia.co.id</a>
                </p>
                <p>WhatsApp:
                    <a href="https://wa.me/6282298859671" class="text-white">+62 822-9885-9671</a>,
                    <a href="https://wa.me/62895400989521" class="text-white">+62 895-4009-89521</a>
                </p>
            </div>
        </div>
    </section>

    <div class="py-3 footer-alt">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="text-center">
                        <p class="mb-0 text-white-50 font-size-15">
                            <script>
                                document.write(new Date().getFullYear())
                            </script> © {{ config('app.name') }}. Crafted with <i
                                class="mdi mdi-heart text-danger"></i> by <a href="https://themesbrand.com/"
                                target="_blank" class="text-white-50">PT Mpedia Nusantara Techwork</a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer End -->

    <!-- login Modal Start -->



    <!-- javascript -->
    <script src="{{ asset('landing/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('landing/js/smooth-scroll.polyfills.min.js') }}"></script>
    <script src="{{ asset('landing/js/gumshoe.polyfills.min.js') }}"></script>
    <!-- feather icon -->
    <script src="{{ asset('landing/js/feather.js') }}"></script>
    <!-- unicons icon -->
    <script src="{{ asset('landing/js/unicons.js') }}"></script>
    <!-- Main Js -->
    <script src="{{ asset('landing/js/app.js') }}"></script>



    <script src="https://mpedia.interaksi.live/js/min/jquery.min.js"></script>
    <script id="sbinit" src="https://mpedia.interaksi.live/js/main.js"></script>

</body>

</html>
