@extends('layouts.master-layouts')

@section('title')
    {{ __('Product') }}
@endsection

@section('content')
    @component('common-components.breadcrumb')
        @slot('title')
            {{ __('Invoice') }}
        @endslot
        @slot('title_li')
        @endslot
    @endcomponent

    <div class="row">
    <div class="col-lg-7">
        <div class="card">
            <div class="card-body p-4">
                <h4 class="card-title mb-4">
                    <i class="fa fa-credit-card me-2"></i> {{ __('Select Payment Method') }}
                </h4>

                <form action="{{ route('invoices.processPayment') }}" method="POST" autocomplete="off">
                    @csrf
                    <input type="hidden" name="invoice_id" value="{{ $invoice->id }}">

                    <div class="row g-3">
                        @foreach ($paymentMethods as $paymentMethod)
                            <div class="col-12 col-md-6">
                                <label for="{{ $paymentMethod->code }}"
                                    class="alert border-primary w-100 d-flex align-items-center"
                                    style="cursor: pointer">
                                    <input type="radio" name="payment_method" id="{{ $paymentMethod->code }}"
                                        value="{{ $paymentMethod->code }}">
                                    <img src="{{ $paymentMethod->image }}" alt="" style="width: 60px"
                                        class="ms-3 flex-shrink-0">
                                    <div class="ms-3 text-dark w-100">
                                        <b>{{ $paymentMethod->name }}</b>
                                        <p class="m-0 small border-bottom border-dark pb-1 mb-1">
                                            {{ __('Admin Fee') }}:
                                            Rp {{ number_format($paymentMethod->fee, 0, ',', '.') }}
                                        </p>
                                        <p class="m-0 small">{{ __('Total') }}:</p>
                                        <p class="m-0">
                                            <b>
                                                Rp {{ number_format($invoice->amount + $paymentMethod->fee, 0, ',', '.') }}
                                            </b>
                                        </p>
                                    </div>
                                </label>
                            </div>
                        @endforeach
                    </div>

                    <div class="mb-3 alert border-warning w-100">
                        <label class="form-label">{{ __('Have a Promo Code?') }}</label>
                        <input type="text" class="form-control" name="discount" value="">
                    </div>

                    <div class="text-end">
                        <button type="submit" class="btn btn-dark w-md">
                            {{ __('Continue') }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

</div>

    <!-- end row -->
@endsection

@section('script')
@endsection
