@extends('layouts.master-layouts')

@section('title')
    {{ __('Products') }}
@endsection

@section('content')
    @component('common-components.breadcrumb')
        @slot('title')
            {{ __('Invoices') }}
        @endslot
        @slot('title_li')
        @endslot
    @endcomponent
    @php
        $paymentDetails = json_decode($invoice->payment_details, true);
    @endphp
    <div class="row">
        <div class="col-lg-7">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title m-0"><i class="fa fa-receipt me-2"></i> {{ __('Invoice') }} #{{ $invoice->invoice_number }}
                    </h4>
                </div>
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between flex-column flex-md-row">
                        <div class="mb-3">
                            <h2 class="m-0">{{ config('app.name') }}</h2>
                            <p class="m-0">PT CITRA SELARAS INTEGRASI</p>
                        </div>
                        <div class="">
                            <table>
                                <tbody>
                                    <tr>
                                        <td class="align-top">{{ __('To') }}</td>
                                        <td class="align-top px-1">:</td>
                                        <td class="align-top">
                                            <b>{{$invoice->user->name}}<br>{{$invoice->user->email}}</b>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="align-top">{{ __('Date') }}</td>
                                        <td class="align-top px-1">:</td>
                                        <td class="align-top">
                                            <b>{{ $invoice->created_at->format('d F Y H:i') }}</b>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="align-top">{{ __('Due Date') }}</td>
                                        <td class="align-top px-1">:</td>
                                        <td class="align-top">
                                            <b>{{ $invoice->expired_at }}</b>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="align-top">{{ __('Payment Method') }}</td>
                                        <td class="align-top px-1">:</td>
                                        <td class="align-top">
                                            <b>{{ $paymentDetails['type'] }}</b>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @if ($invoice->status == 'unpaid')
                        <div class="my-4 alert alert-warning bg-soft-warning text-center text-uppercase">
                            <b>{{ __('Unpaid') }}</b>
                        </div>
                    @elseif ($invoice->status == 'paid')
                        <div class="my-4 alert alert-success bg-soft-success text-center text-uppercase">
                            <b>{{ __('Paid') }}</b>
                        </div>
                    @else
                        <div class="my-4 alert  alert-danger bg-soft-danger text-center text-uppercase">
                            <b>{{ __('Cancelled') }}</b>
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered mb-0">
                            <tbody>
                                <tr>
                                    <th>{{ __('Description') }}</th>
                                    <th>{{ __('Amount') }}</th>
                                </tr>
                                <tr>
                                    <td>{{ $invoice->description }}</td>
                                    <td>Rp {{ number_format($invoice->amount, 0, ',', '.') }}</td>
                                </tr>
                                <tr>
                                    <td class="text-end"><b>{{ __('Subtotal') }}</b></td>
                                    <td>Rp {{ number_format($invoice->amount, 0, ',', '.') }}</td>
                                </tr>
                                <tr>
                                    <td class="text-end"><b>{{ __('Admin Fee') }}</b></td>
                                    <td>Rp {{ number_format($invoice->tax, 0, ',', '.') }}</td>
                                </tr>
                                <tr>
                                    <td class="text-end"><b>{{ __('Total') }}</b></td>
                                    <td>Rp {{ number_format($invoice->amount + $invoice->tax, 0, ',', '.') }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        @if ($invoice->status == 'unpaid')
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title m-0"><i class="fa fa-question me-2"></i> {{ __('Payment Instructions') }}
                        </h4>
                    </div>
                    <div class="card-body overflow-hidden position-relative p-4">
                        <div>
                            <i class="bx bx-help-circle widget-box-1-icon text-primary"></i>
                        </div>
                        <div class="text-center">
   @if (!empty($paymentDetails['qr_code']))
                        {{-- Tampilkan QR Code --}}
                        <p>{{ __('Scan this QR Code to pay') }}</p>
                        <img src="https://api.qrserver.com/v1/create-qr-code/?size=250x250&data={{ urlencode($paymentDetails['qr_code']) }}" alt="QR Code" class="img-fluid" />
                    @elseif (isset($paymentDetails['paymentUrl']))
                        {{-- Tampilkan Tombol Pembayaran --}}
                        <a target="_blank" href="{{ $paymentDetails['paymentUrl'] }}" class="btn btn-primary btn-sm text-white">
                            {{ __('Click here to pay') }}
                        </a>
                    @else
                        {{-- Tampilkan Info Bank --}}
                        <h4 class="m-0">{{ __('Bank') }}: {{ $paymentDetails['bank_account'] }}</h4>
                        <h4 class="m-0">{{ __('Account Name') }}: {{ $paymentDetails['bank_account_name'] }}</h4>
                    @endif
</div>

                    </div>
                </div>
            </div>
        @endif
    </div>
@endsection

@section('script')
@endsection

