@extends('layouts.master-layouts')

@section('title')
    {{ __('Dashboard') }}
@endsection
@section('css')
    <!-- DataTables -->
    <link href="{{ URL::asset('/libs/datatables/datatables.min.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('content')
    <div class="container-fluid">
        @component('common-components.breadcrumb')
            @slot('title')
                {{ __('Dashboard') }}
            @endslot
            @slot('title_li')
            @endslot
        @endcomponent

        <div class="card card-body">
            <div class="d-flex align-items-center">
                <img src="https://upload.wikimedia.org/wikipedia/commons/5/5e/WhatsApp_icon.png" alt="WhatsApp" width="50px">
                <div class="ms-2">
                    {{ __('Join the group') }} {{ config('app.name') }} {{ __('on WhatsApp to get updates, promotions, etc.') }}<br>
                    <a href="#" target="_blank">{{ __('Click Here to Join') }}</a>
                </div>
            </div>
        </div>

        <div class="row">
            @if ($firstUnpaidPayment)
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title m-0"><i class="fa fa-exclamation-circle me-2"></i> {{ __('Unpaid Invoice') }}</h4>
                        </div>
                        <div class="card-body p-4">
                            <div class="row">
                                <div class="col-md-6 col-lg-12">
                                    <div class="card">
                                        <div class="card-header d-flex justify-content-between align-items-center">
                                            <h4 class="card-title m-0"><i class="fa fa-receipt me-2"></i> {{ __('Invoice') }} #{{ $firstUnpaidPayment->id }}</h4>
                                            <p class="m-0 text-success fw-bold">Rp
                                                {{ number_format($firstUnpaidPayment->amount + $firstUnpaidPayment->tax, 0, ',', '.') }}
                                            </p>
                                        </div>
                                        <div class="card-body overflow-hidden position-relative p-4">
                                            <div>
                                                <i class="fa fa-receipt widget-box-1-icon text-primary"></i>
                                            </div>
                                            <h6>{{ __('Deadline:') }}</h6>
                                            <p>{{ \Carbon\Carbon::parse($firstUnpaidPayment->expired_at)->format('d M Y H:i') }}</p>
                                            <h6>{{ __('Description:') }}</h6>
                                            <p>{{ $firstUnpaidPayment->description }}</p>
                                            <a class="btn btn-sm btn-secondary w-100"
                                                href="{{ route('invoices.payment', $firstUnpaidPayment->invoice_number) }}">{{ __('Pay Now') }}</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <a href="{{ route('invoices.index') }}" class="btn btn-sm btn-primary w-100">{{ __('View All') }}</a>
                        </div>
                    </div>
                </div>
            @endif
            <div class="col-lg">
                <div class="row">
                    <div class="col-md">
                        <div class="card">
                            <div class="card-body overflow-hidden position-relative">
                                <div>
                                    <i class="fa fa-boxes widget-box-1-icon text-primary"></i>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <span>{{ __('Active Subscription') }}</span>
                                        <h4 class="mt-2">{{ $user->activeSubscriptionCount }}</h4>
                                    </div>
                                    <div class="text-end">
                                        <i class="fa fa-fw fa-2x fa-boxes text-primary"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md">
                        <div class="card">
                            <div class="card-body overflow-hidden position-relative">
                                <div>
                                    <i class="fa fa-boxes widget-box-1-icon text-success"></i>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <span>{{ __('Inactive Subscription') }}</span>
                                        <h4 class="mt-2">{{ $user->inactiveSubscriptionCount }}</h4>
                                    </div>
                                    <div class="text-end">
                                        <i class="fa fa-fw fa-2x fa-boxes text-success"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md">
                        <div class="card">
                            <div class="card-body overflow-hidden position-relative">
                                <div>
                                    <i class="fa fa-boxes widget-box-1-icon text-secondary"></i>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <span>{{ __('Unpaid Invoice') }}</span>
                                        <h4 class="mt-2">{{ $user->unpaidPaymentCount }}</h4>
                                    </div>
                                    <div class="text-end">
                                        <i class="fa fa-fw fa-2x fa-boxes text-secondary"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md">
                        <div class="card">
                            <div class="card-body overflow-hidden position-relative">
                                <div>
                                    <i class="fa fa-globe widget-box-1-icon text-primary"></i>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <span>{{ __('Paid Invoice') }}</span>
                                        <h4 class="mt-2">{{ $user->paidPaymentCount }}</h4>
                                    </div>
                                    <div class="text-end">
                                        <i class="fa fa-fw fa-2x fa-globe text-primary"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- end row -->
@endsection
<!-- Modal untuk menampilkan detail langganan -->

@section('script')
    <!-- Required datatable js -->
@endsection
