@extends('layouts.master-without-nav')

@section('title')
    {{ __('Login') }}
@endsection

@section('body')

    <body>
    @endsection

    @section('content')
        <div class="home-btn d-none d-sm-block">
            <a href="{{ route('products.index') }}" class="text-dark"><i class="fas fa-home h2"></i></a>
        </div>
        <div class="account-pages my-5 pt-sm-5">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6 col-xl-5">
                        <div class="card overflow-hidden">
                            <div class="bg-login text-center">
                                <div class="bg-login-overlay"></div>
                                <div class="position-relative">
                                    <p class="text-white-50 mb-0">{{ __('Sign in to continue to') }} {{ config('app.name') }}.</p>
                                    <a href="index" class="logo logo-admin mt-4">
                                        <img src="images/logo-sm-dark.png" alt="" height="40">
                                    </a>
                                </div>
                            </div>
                            <div class="card-body pt-5">
                                <div class="p-2">
                                    <form method="POST" action="{{ route('login') }}">
                                        @csrf
                                        <div class="form-group">
                                            <label for="username">{{ __('E-Mail Address') }}</label>
                                            <input id="email" type="email"
                                                class="form-control @error('email') is-invalid @enderror" name="email"
                                                @if (old('email')) value="{{ old('email') }}" @else value="" @endif
                                                required autocomplete="email" autofocus>
                                            @error('email')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="userpassword">{{ __('Password') }}</label>
                                            <input id="password" type="password"
                                                class="form-control @error('password') is-invalid @enderror" name="password"
                                                required autocomplete="current-password">
                                            @error('password')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="remember"
                                                id="customControlInline" {{ old('remember') ? 'checked' : '' }}>
                                            <label class="custom-control-label"
                                                for="customControlInline">{{ __('Remember Me') }}</label>
                                        </div>

                                        <div class="mt-3">
                                            <button class="btn btn-primary btn-block waves-effect waves-light"
                                                id="login" type="submit">{{ __('Login') }}</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="mt-5 text-center">
                            ©
                            <script>
                                document.write(new Date().getFullYear())
                            </script> INTEGRASICHAT.COM. {{ __('Crafted with') }} <i class="mdi mdi-heart text-danger"></i>
                            {{ __('by') }}
                            <a href="https://citraselarasintegrasi.com" target="_blank">PT CITRA SELARAS INTEGRASI</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- JAVASCRIPT -->
        <script src="{{ URL::asset('libs/jquery/jquery.min.js') }}"></script>
        <script src="{{ URL::asset('libs/bootstrap/bootstrap.min.js') }}"></script>
        <script src="{{ URL::asset('libs/metismenu/metismenu.min.js') }}"></script>
        <script src="{{ URL::asset('libs/simplebar/simplebar.min.js') }}"></script>
        <script src="{{ URL::asset('libs/node-waves/node-waves.min.js') }}"></script>

        <script src="{{ URL::asset('js/app.min.js') }}"></script>
    @endsection
