@extends('layouts.master')

@section('title', 'Edit Subscription')
@section('css')
<!-- DataTables -->

@endsection
@section('content')
@component('common-components.breadcrumb')
@slot('title')
Edit Subscription
@endslot
@slot('title_li')
{{ $subscription->product }}
@endslot
@endcomponent

<div class="row">
    <div class="col-lg-12 mx-auto">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title mb-0">Edit Subscription Details</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.subscriptions.update', $subscription->id) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <!-- User (Disabled for editing) -->
                    <div class="mb-3">
                        <label for="user_id" class="form-label">User</label>
                        <input type="hidden" class="form-control" id="user_id" name="user_id"
                            value="{{ $subscription->user->id }}">
                        <input type="text" class="form-control" id="user" name="user"
                            value="{{ $subscription->user->name }}" disabled>
                    </div>

                    <!-- Product -->
                    <div class="mb-3">
                        <label for="product" class="form-label">Product</label>
                        <input type="text" class="form-control @error('product') is-invalid @enderror" id="product"
                            name="product" value="{{ old('product', $subscription->product) }}">
                        @error('product')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="domain" class="form-label">Domain/subdomain</label>
                        <input type="text" class="form-control @error('domain') is-invalid @enderror" id="domain"
                            name="domain" value="{{ old('domain', $subscription->domain) }}">
                        @error('domain')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Status -->


                    <!-- Start Date -->
                    <div class="mb-3">
                        <label for="start_date" class="form-label">Start Date</label>
                        <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                            id="start_date" name="start_date"
                            value="{{ old('start_date', $subscription->start_date) }}">
                        @error('start_date')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Due Date -->
                    <div class="mb-3">
                        <label for="due_date" class="form-label">Due Date</label>
                        <input type="date" class="form-control @error('due_date') is-invalid @enderror"
                            id="due_date" name="due_date" value="{{ old('due_date', $subscription->due_date) }}">
                        @error('due_date')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    {{-- textarea detail --}}
                    <div class="mb-3">
                        <label for="details" class="form-label">Details</label>
                        <textarea class="form-control @error('details') is-invalid @enderror" id="details" name="details">{{ old('details', $subscription->details) }}</textarea>
                        @error('details')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- NS -->
                    <div class="mb-3">
                        <label for="ns" class="form-label">NS</label>
                        <input type="text" class="form-control @error('ns') is-invalid @enderror" id="ns"
                            name="ns" value="{{ old('ns', $subscription->ns) }}">
                        @error('ns')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <div>
                            @foreach (['active', 'inactive', 'suspend', 'waiting', 'processing'] as $status)
                            <div class="form-check form-check-inline">
                                <input
                                    class="form-check-input @error('status') is-invalid @enderror"
                                    type="radio"
                                    name="status"
                                    id="status_{{ $status }}"
                                    value="{{ $status }}"
                                    {{ $subscription->status == $status ? 'checked' : '' }}>
                                <label class="form-check-label" for="status_{{ $status }}">
                                    {{ ucfirst($status) }}
                                </label>
                            </div>
                            @endforeach
                            @error('status')
                            <div class="invalid-feedback d-block">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="text-end">
                        <button type="submit" class="btn btn-success">Update Subscription</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')]
@endsection