@extends('layouts.master')

@section('title', 'Edit Server')

@section('content')
    @component('common-components.breadcrumb')
        @slot('title')
            Edit Server
        @endslot
    @endcomponent

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>Edit Server</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.servers.update', $server->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="mb-3">
                            <label for="host" class="form-label">Host</label>
                            <input type="text" class="form-control @error('host') is-invalid @enderror" id="host"
                                name="host" value="{{ old('host', $server->host) }}" required>
                            @error('host')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="panel_url" class="form-label">Panel URL</label>
                            <input type="text" class="form-control @error('panel_url') is-invalid @enderror"
                                id="panel_url" name="panel_url" value="{{ old('panel_url', $server->panel_url) }}" required>
                            @error('panel_url')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="username" class="form-label">Username</label>
                            <input type="text" class="form-control @error('username') is-invalid @enderror"
                                id="username" name="username" value="{{ old('username', $server->username) }}" required>
                            @error('username')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="sshkey" class="form-label">SSH Key</label>
                            <textarea class="form-control @error('sshkey') is-invalid @enderror" id="sshkey" name="sshkey" rows="4"
                                required>{{ old('sshkey', $server->sshkey) }}</textarea>
                            @error('sshkey')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="is_open" class="form-label">Is Open</label>
                            <select class="form-select @error('is_open') is-invalid @enderror" id="is_open" name="is_open"
                                required>
                                <option value="1" {{ $server->is_open ? 'selected' : '' }}>Yes</option>
                                <option value="0" {{ !$server->is_open ? 'selected' : '' }}>No</option>
                            </select>
                            @error('is_open')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="port" class="form-label">Port</label>
                            <input type="number" class="form-control @error('port') is-invalid @enderror" id="port"
                                name="port" value="{{ old('port', $server->port) }}" required>
                            @error('port')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="dbuser" class="form-label">Database User</label>
                            <input type="text" class="form-control @error('dbuser') is-invalid @enderror" id="dbuser"
                                name="dbuser" value="{{ old('dbuser', $server->dbuser) }}">
                            @error('dbuser')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="dbpass" class="form-label">Database Password</label>
                            <input type="password" class="form-control @error('dbpass') is-invalid @enderror" id="dbpass"
                                name="dbpass" value="{{ old('dbpass', $server->dbpass) }}">
                            @error('dbpass')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="panel_api_key" class="form-label">Panel API Key</label>
                            <input type="text" class="form-control @error('panel_api_key') is-invalid @enderror"
                                id="panel_api_key" name="panel_api_key"
                                value="{{ old('panel_api_key', $server->panel_api_key) }}">
                            @error('panel_api_key')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div>
                            <button type="submit" class="btn btn-success">Update Server</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
