@extends('layouts.master')

@section('title', 'Daftar Subdomain')

@push('css')
<link href="{{ URL::asset('build/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css') }}" rel="stylesheet" />
<link href="{{ URL::asset('build/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css') }}" rel="stylesheet" />
<link href="{{ URL::asset('build/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css') }}" rel="stylesheet" />
@endpush

@section('content')
@component('common-components.breadcrumb')
@slot('title') Daftar Subdomain Cloudflare @endslot
@endcomponent

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="alert alert-warning" role="alert">
                    <strong>Perhatian!</strong> Data subdomain ini terhubung langsung dengan Cloudflare.<br>
                    Jika Anda menghapus subdomain di sini, subdomain tersebut akan <u>langsung dihapus dari Cloudflare</u> juga.
                </div>

                <h4 class="card-title">Subdomain</h4>
                <table class="table table-bordered dt-responsive data-table nowrap" style="width: 100%;">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Subdomain</th>
                            <th>Tipe</th>
                            <th>Tujuan</th>
                            <th>Tanggal Dibuat</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script src="{{ URL::asset('build/libs/datatables.net/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons-bs4/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/jszip/jszip.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/pdfmake/build/pdfmake.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/pdfmake/build/vfs_fonts.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.html5.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.print.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.colVis.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js') }}"></script>

<script>
    $(function() {
        $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('domains.index') }}",
                type: "GET"
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'content',
                    name: 'content'
                },
                {
                    data: 'created_on',
                    name: 'created_on'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                },
            ]
        });
    });

    $(document).on('click', '.delete-domain', function() {
        const url = $(this).data('url');
        confirmAction("Yakin ingin menghapus subdomain?", "Subdomain ini akan dihapus dari Cloudflare!", function() {
            $.ajax({
                url: url,
                type: 'DELETE',
                success: function(response) {
                    $('.data-table').DataTable().ajax.reload();
                    swal("Berhasil!", "Subdomain telah dihapus.", "success");
                },
                error: function(xhr) {
                    swal("Gagal menghapus subdomain: " + xhr.responseText, {
                        icon: "error"
                    });
                }
            });
        }, function() {
            swal("Dibatalkan", "Subdomain tidak jadi dihapus", "error");
        });
    });
</script>
@endpush
