@extends('layouts.master')

@section('title', 'Detail Server - Subdomain')

@push('css')
<link href="{{ URL::asset('build/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css') }}" rel="stylesheet" />
<link href="{{ URL::asset('build/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css') }}" rel="stylesheet" />
<link href="{{ URL::asset('build/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css') }}" rel="stylesheet" />
@endpush

@section('content')
@component('common-components.breadcrumb')
@slot('title') Detail Server: {{ $server->host }} @endslot
@endcomponent

<div class="row">
    <div class="col-12">
        <div class="alert alert-warning" role="alert">
            <strong>Perhatian!</strong> Data subdomain ini terhubung langsung dengan Cloudflare.<br>
            Jika Anda menghapus subdomain di sini, subdomain tersebut akan <u>langsung dihapus dari Cloudflare</u> juga.
        </div>

        {{-- Server Info --}}
        <div class="card mb-3">
            <div class="card-body">
                <h5 class="card-title">Informasi Server</h5>
                <p class="mb-0"><strong>Host:</strong> {{ $server->host }}</p>
            </div>
        </div>

        {{-- Logs --}}
        <div class="card mb-3">
            <div class="card-body">
                <h5 class="card-title">Aktivitas Terakhir</h5>
                <div style="background-color: #1e1e1e; color: #d4d4d4; padding: 15px; font-family: monospace; font-size: 13px; max-height: 300px; overflow-y: auto; border-radius: 5px;">
                    @forelse($logs['data'] as $log)

                    <div style="border-bottom: 1px solid #333; padding: 6px 0;">
                        <span style="color:#6A9955;">[{{ $log['addtime'] ?? '-' }}]</span>
                        <span style="color:#569CD6;">({{ $log['type'] ?? 'UNKNOWN' }})</span>
                        <span style="color:#DCDCAA;">{{ $log['username'] ?? 'user' }}:</span>
                        <span>{{ $log['log'] ?? '-' }}</span>
                    </div>
                    @empty
                    <div class="text-muted">Tidak ada log tersedia.</div>
                    @endforelse
                </div>
            </div>
        </div>



        {{-- Subdomain Table --}}
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Daftar Subdomain</h4>
                <table class="table table-bordered dt-responsive data-table nowrap" style="width: 100%;">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Nama</th>
                            <th>SSL Expiry</th>
                            <th>Status</th>
                            <th>Dibuat</th>

                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script src="{{ URL::asset('build/libs/datatables.net/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons-bs4/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/jszip/jszip.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/pdfmake/build/pdfmake.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/pdfmake/build/vfs_fonts.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.html5.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.print.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.colVis.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js') }}"></script>

<script>
    $(function() {
        $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('admin.servers.detail', $server->id) }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'ssl_expiry',
                    name: 'ssl_expiry'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'addtime',
                    name: 'addtime'
                },
             
            ]
        });
    });
</script>
@endpush
