@extends('layouts.master')

@section('title', 'Create Server')

@section('content')
@component('common-components.breadcrumb')
@slot('title')
Create Server
@endslot
@endcomponent

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5>Create Server</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.servers.store') }}" method="POST">
                    @csrf

                    <div class="mb-3">
                        <label for="host" class="form-label">Host</label>
                        <input type="text" class="form-control @error('host') is-invalid @enderror" id="host"
                            name="host" value="{{ old('host') }}" required>
                        @error('host')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="panel_url" class="form-label">Panel URL</label>
                        <input type="text" class="form-control @error('panel_url') is-invalid @enderror"
                            id="panel_url" name="panel_url" value="{{ old('panel_url') }}" required>
                        @error('panel_url')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="username" class="form-label">Username</label>
                        <input type="text" class="form-control @error('username') is-invalid @enderror"
                            id="username" name="username" value="{{ old('username') }}" required>
                        @error('username')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="sshkey" class="form-label">SSH Key</label>
                        <textarea class="form-control @error('sshkey') is-invalid @enderror" id="sshkey" name="sshkey" rows="4"
                            required>{{ old('sshkey') }}</textarea>
                        @error('sshkey')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="is_open" class="form-label">Is Open</label>
                        <select class="form-select @error('is_open') is-invalid @enderror" id="is_open" name="is_open"
                            required>
                            <option value="1" {{ old('is_open') == '1' ? 'selected' : '' }}>Yes</option>
                            <option value="0" {{ old('is_open') == '0' ? 'selected' : '' }}>No</option>
                        </select>
                        @error('is_open')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="port" class="form-label">Port</label>
                        <input type="number" class="form-control @error('port') is-invalid @enderror" id="port"
                            name="port" value="{{ old('port') }}" required>
                        @error('port')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3 d-none">
                        <label for="dbuser" class="form-label">Database User</label>
                        <input type="text" class="form-control @error('dbuser') is-invalid @enderror" id="dbuser"
                            name="dbuser" value="{{ old('dbuser') }}">
                        @error('dbuser')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3 d-none">
                        <label for="dbpass" class="form-label">Database Password</label>
                        <input type="password" class="form-control @error('dbpass') is-invalid @enderror" id="dbpass"
                            name="dbpass" value="{{ old('dbpass') }}">
                        @error('dbpass')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="panel_api_key" class="form-label">Panel API Key</label>
                        <input type="text" class="form-control @error('panel_api_key') is-invalid @enderror"
                            id="panel_api_key" name="panel_api_key" value="{{ old('panel_api_key') }}">
                        @error('panel_api_key')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div>
                        <button type="submit" class="btn btn-primary">Create Server</button>
                        <button id="checkApiConnection" type="button" class="btn btn-success">Tes koneksi api</button>
                        <button id="checkSshConnection" type="button" class="btn btn-warning">Tes koneksi ssh</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')

<script>
    $(document).ready(function() {

        function check(type) {
            const panelApiKey = $("#panel_api_key").val();
            const panelUrl = $("#panel_url").val();
            const host = $("#host").val();

            const username = $("#username").val();
            const sshKey = $("#sshkey").val();
            const port = $("#port").val();



            $.ajax({
                url: "{{ route('server.test') }}",
                type: 'POST',
                data: {
                    type: type,
                    aapanelUrl: panelUrl,
                    aapanelKey: panelApiKey,
                    host,
                    username,
                    port,
                    sshKey
                },
                success: function(response) {
                    if (response?.status === false) {
                        Swal.fire("Failed", response?.msg);
                        return;
                    }

                    let logs = '';

                    if (Array.isArray(response.data)) {
                        // ====> UNTUK TIPE API (ARRAY OF LOGS)
                        logs = response.data.map(item => {
                            return `<div style="text-align:left; margin-bottom:10px;">
                <strong>${item.type}</strong><br/>
                <small>${item.addtime}</small><br/>
                <pre style="background:#f0f0f0; padding:10px;">${item.log}</pre>
            </div>`;
                        }).join('');
                    } else {
                        // ====> UNTUK TIPE SSH (OBJECT)
                        const data = response.data;

                        logs = `
            <div style="text-align:left; margin-bottom:10px;">
                <strong>CPU Usage</strong><br/>
                <pre style="background:#f0f0f0; padding:10px;">${data.cpu}</pre>
            </div>
            <div style="text-align:left; margin-bottom:10px;">
                <strong>Memory Usage</strong><br/>
                <pre style="background:#f0f0f0; padding:10px;">${data.memory}</pre>
            </div>
            <div style="text-align:left; margin-bottom:10px;">
                <strong>Uptime</strong><br/>
                <pre style="background:#f0f0f0; padding:10px;">${data.uptime}</pre>
            </div>
            <div style="text-align:left; margin-bottom:10px;">
                <strong>Disk Usage</strong><br/>
                <pre style="background:#f0f0f0; padding:10px;">${data.disk}</pre>
            </div>
        `;
                    }

                    Swal.fire({
                        title: 'Success, Server Info:',
                        html: logs,
                        width: 800,
                        scrollbarPadding: false,
                        confirmButtonText: 'Close'
                    });
                },

                error: function(xhr) {
                    console.log(xhr)
                    Swal.fire("error", xhr)
                }
            });
        }

        $("#checkApiConnection").on("click", function() {
            check("api");

        })
        $("#checkSshConnection").on("click", function() {
            check("ssh");

        })
    })
</script>
@endpush
