@extends('layouts.master')

@section('title', 'Daftar Servers')

@push('css')
<!-- DataTables -->
<link href="{{ URL::asset('build/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
<link href="{{ URL::asset('build/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />

<!-- Responsive datatable examples -->
<link href="{{ URL::asset('build/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
@endpush

@section('content')
@component('common-components.breadcrumb')
@slot('title')
Daftar Servers
@endslot
@endcomponent

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header justify-content-end d-flex">
                <a href="{{ route('admin.payment_methods.create') }}" class="btn btn-primary float-end">Tambah Method</a>
            </div>

            <div class="card-body">
                <h4 class="card-title">Servers</h4>
                <table class="table table-bordered dt-responsive data-table nowrap" style="width: 100%;">
                    <thead>
                        <tr>
                            <th>image</th>
                            <th>Provider</th>
                            <th>Type</th>
                            <th>Manual</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<!-- Required datatable js -->
<script src="{{ URL::asset('build/libs/datatables.net/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<!-- Buttons examples -->
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons-bs4/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/jszip/jszip.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/pdfmake/build/pdfmake.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/pdfmake/build/vfs_fonts.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.html5.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.print.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.colVis.min.js') }}"></script>
<!-- Responsive examples -->
<script src="{{ URL::asset('build/libs/datatables.net-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js') }}"></script>

<!-- Datatable init js -->
<script src="{{ URL::asset('build/js/pages/datatables.init.js') }}"></script>
<script src="{{ URL::asset('build/js/app.js') }}"></script>
<script>
    $(function() {
        $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('admin.payment_methods.index') }}",
            columns: [{
                    data: 'image',
                    name: 'image'
                },
                {
                    data: 'provider',
                    name: 'provider'
                },
                {
                    data: 'type',
                    name: 'type'
                },

                {
                    data: 'manual',
                    name: 'manual'
                },
                {
                    data: 'status',
                    name: 'status',

                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });
    });

    $(document).on('click', '.delete', function() {
        const url = $(this).attr('data-url');
        confirmAction("Anda yakin?", "Data terkait akan terhapus secara permanen!", function() {
            $.ajax({
                url: url,
                type: 'DELETE',
                success: function(response) {
                    $('.data-table').DataTable().ajax.reload();
                    Swal.fire("Success!", "Method has been deleted.", "success");
                },
                error: function(xhr) {
                    Swal.fire("Error deleting server: " + xhr.responseText, {
                        icon: "error"
                    });
                }
            });
        }, function() {
            Swal.fire("Server deletion canceled!", "Your data is safe :)", "error");
        });
    });

    // Toggle Aktif/Tidak
    $(document).on('click', '.toggle-status', function() {
        const id = $(this).data('id');
        const url = '{{ url("admin/payment-methods") }}/' + id + '/toggle';

        $.post(url, {
            _token: '{{ csrf_token() }}'
        }, function(response) {

            $('.data-table').DataTable().ajax.reload();

        });
    });
</script>
@endpush