@extends('layouts.master')

@section('title', 'Create Payment')

@section('content')
@component('common-components.breadcrumb')
@slot('title')
Create Payment
@endslot
@endcomponent

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5>Create Payment</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.payment_methods.store') }}" method="POST">
                    @csrf

                    <div class="mb-3">
                        <label for="code" class="form-label">Code</label>
                        <input type="text" class="form-control @error('code') is-invalid @enderror" id="code" name="code" value="{{ old('code') }}" required>
                        @error('code')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="type" class="form-label">Type</label>
                        <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                            <option value="">Select Type</option>
                            <option value="VA" {{ old('type') == 'VA' ? 'selected' : '' }}>VA</option>
                            <option value="QRIS" {{ old('type') == 'QRIS' ? 'selected' : '' }}>QRIS</option>
                            <option value="Bank Transfer" {{ old('type') == 'Bank Transfer' ? 'selected' : '' }}>Bank Transfer</option>
                            <option value="EWALLET" {{ old('type') == 'EWALLET' ? 'selected' : '' }}>E-Wallet</option>
                            <option value="RETAIL" {{ old('type') == 'RETAIL' ? 'selected' : '' }}>Retail</option>
                            <option value="OVO" {{ old('type') == 'OVO' ? 'selected' : '' }}>OVO</option>
                        </select>
                        @error('type')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="name" class="form-label">Method Name</label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="bank_account_name" name="name" value="{{ old('bank_account_name') }}">
                        @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="bank_account_name" class="form-label">Bank Account Name</label>
                        <input type="text" class="form-control @error('bank_account_name') is-invalid @enderror" id="bank_account_name" name="bank_account_name" value="{{ old('bank_account_name') }}">
                        @error('bank_account_name')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="bank_account" class="form-label">Bank Account</label>
                        <input type="text" class="form-control @error('bank_account') is-invalid @enderror" id="bank_account" name="bank_account" value="{{ old('bank_account') }}">
                        @error('bank_account')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="image" class="form-label">Image URL</label>
                        <input type="text" class="form-control @error('image') is-invalid @enderror" id="image" name="image" value="{{ old('image') }}">
                        @error('image')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="provider" class="form-label">Provider</label>
                        <select class="form-select @error('provider') is-invalid @enderror" id="provider" name="provider" required>
                            <option value="">Select Provider</option>
                            <option value="ipaymu" {{ old('provider') == 'ipaymu' ? 'selected' : '' }}>iPaymu</option>
                            <option value="duitku" {{ old('provider') == 'duitku' ? 'selected' : '' }}>Duitku</option>
                            <option value="manual" {{ old('provider') == 'manual' ? 'selected' : '' }}>Manual</option>
                        </select>
                        @error('provider')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="is_manual" class="form-label">Is Manual</label>
                        <select class="form-select @error('is_manual') is-invalid @enderror" id="is_manual" name="is_manual" required>
                            <option value="1" {{ old('is_manual') == '1' ? 'selected' : '' }}>Yes</option>
                            <option value="0" {{ old('is_manual') == '0' ? 'selected' : '' }}>No</option>
                        </select>
                        @error('is_manual')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="is_active" class="form-label">Is Active</label>
                        <select class="form-select @error('is_active') is-invalid @enderror" id="is_active" name="is_active" required>
                            <option value="1" {{ old('is_active') == '1' ? 'selected' : '' }}>Yes</option>
                            <option value="0" {{ old('is_active') == '0' ? 'selected' : '' }}>No</option>
                        </select>
                        @error('is_active')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div>
                        <button type="submit" class="btn btn-primary">Create Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection