@extends('layouts.master')

@section('title', 'Daftar Packages')

@push('css')
<!-- DataTables -->
<link href="{{ URL::asset('build/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
<link href="{{ URL::asset('build/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />

<!-- Responsive datatable examples -->
<link href="{{ URL::asset('build/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css') }}" rel="stylesheet" type="text/css" />
@endpush

@section('content')
@component('common-components.breadcrumb')
@slot('title')
Daftar Packages
@endslot
@slot('title_li')
@endslot
@endcomponent

<div class="row">
    <div class="col-12">
        <div class="card">
            {{-- button tambah --}}
            <div class="card-header justify-content-end d-flex">

                <a href="{{ route('admin.packages.create') }}" class="btn btn-primary float-end">Tambah Package</a>
            </div>

            <div class="card-body">
                <h4 class="card-title">Packages</h4>
                <table class="table table-bordered dt-responsive data-table nowrap" style="width: 100%;">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Product</th>
                            <th>Title</th>
                            <th>Price</th>
                            <th>Duration (days)</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<!-- Required datatable js -->
<script src="{{ URL::asset('build/libs/datatables.net/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<!-- Buttons examples -->
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons-bs4/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/jszip/jszip.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/pdfmake/build/pdfmake.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/pdfmake/build/vfs_fonts.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.html5.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.print.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-buttons/js/buttons.colVis.min.js') }}"></script>
<!-- Responsive examples -->
<script src="{{ URL::asset('build/libs/datatables.net-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ URL::asset('build/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js') }}"></script>

<!-- Datatable init js -->
<script src="{{ URL::asset('build/js/pages/datatables.init.js') }}"></script>
<script src="{{ URL::asset('build/js/app.js') }}"></script>
<script>
    $(function() {
        $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('admin.packages.index') }}",
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'product',
                    name: 'product.name'
                },
                {
                    data: 'title',
                    name: 'title'
                },
                {
                    data: 'price',
                    name: 'price'
                },
                {
                    data: 'duration',
                    name: 'duration'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });
    });

    $(document).on('click', '.delete', function() {

        const url = $(this).attr('data-url');
        confirmAction(
            "Anda yakin?",
            "Data terkait akan terhapus secara permanen!",
            function() {
                $.ajax({
                    url: url,
                    type: 'DELETE',
                    success: function(response) {
                        // Refresh DataTable setelah berhasil menghapus
                        $('.data-table').DataTable().ajax.reload();
                        Swal.fire({
                            title: "Success!",
                            text: "Package has been deleted.",
                            icon: "success",
                        });
                    },
                    error: function(xhr) {
                        Swal.fire("Error deleting package: " + xhr.responseText, {
                            icon: "error",
                        });
                    }
                });
            },
            function() {
                // Tindakan ketika pengguna menekan Cancel
                Swal.fire("Package deletion canceled!", "Your user is safe :)", "error");
            }
        );
    });
</script>


@endpush
