@extends('layouts.master')

@section('title')
Dashboard
@endsection


@section('content')
<div class="container-fluid">
    @component('common-components.breadcrumb')
    @slot('title')
    Dashboard
    @endslot
    @endcomponent



    <div class="row">
        <!-- Statistik Section -->
        <div class="col-lg-3 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <h5 class="card-title">Total Subscription Aktif</h5>
                    <p class="display-4 text-success">{{ $activeSubscriptionCount }}</p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <h5 class="card-title">Total Subscription Tidak Aktif</h5>
                    <p class="display-4 text-warning">{{ $inactiveSubscriptionCount }}</p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <h5 class="card-title">Total Pembayaran Belum Dibayar</h5>
                    <p class="display-4 text-danger">{{ $unpaidPaymentCount }}</p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 mb-4">
            <div class="card">
                <div class="card-body text-center">
                    <h5 class="card-title">Total Pembayaran Sudah Dibayar</h5>
                    <p class="display-4 text-primary">{{ $paidPaymentCount }}</p>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header">
                    Grafik Total Pembayaran (Paid) per Bulan - {{ now()->year }}
                </div>
                <div class="card-body">
                    <canvas id="monthlyPaidChart" height="120"></canvas>
                </div>
            </div>
        </div>
    </div>



</div>

@endsection
@push('script')
<!-- Chart JS -->
<script src="{{ URL::asset('build/libs/chart.js/chart.umd.js') }}"></script>
<script src="{{ URL::asset('build/js/pages/chartjs.init.js') }}"></script>
<script src="{{ URL::asset('build/js/app.js') }}"></script>
<script>
    const ctx = document.getElementById('monthlyPaidChart').getContext('2d');

    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: [
                'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'
            ],
            datasets: [{
                label: 'Total Paid',
                data: @json($paidData),
                backgroundColor: '#007bff'
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return 'Rp ' + value.toLocaleString();
                        }
                    }
                }
            },
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'Rp ' + context.raw.toLocaleString();
                        }
                    }
                }
            }
        }
    });
</script>

@endpush
