@extends('layouts.master-layouts')

@section('title')
    {{ __('Account Settings') }}
@endsection
@section('css')
    <!-- DataTables -->
    <link href="{{ URL::asset('/libs/datatables/datatables.min.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('content')
    @component('common-components.breadcrumb')
        @slot('title')
            {{ __('Account Settings') }}
        @endslot
        @slot('title_li')
        @endslot
    @endcomponent
    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title m-0"><i class="fa fa-cogs me-2"></i> {{ __('Account Settings') }}</h4>
                </div>
                <div class="card-body p-4">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('account.updateSettings') }}" autocomplete="off">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('Email') }} (<small class="text-muted">{{ __('Cannot be changed.') }}</small>)
                                        <i class="ms-1 text-success fas fa-check-circle"></i></label>
                                    <span class="form-control">{{ $user->email }}</span>
                                </div>
                            </div>
                            <div class="col-md">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('WhatsApp Number') }} <i
                                            class="ms-1 text-success fas fa-check-circle"></i></label>
                                    <input type="text" class="form-control" name="whatsapp"
                                        value="{{ old('whatsapp', $user->whatsapp) }}">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('Full Name') }}</label>
                                    <input type="text" class="form-control" name="name"
                                        value="{{ old('name', $user->name) }}">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('New Password') }}</label>
                                    <input type="password" class="form-control" name="new_password">
                                    <small class="text-muted">*{{ __('Leave blank if not changing.') }}</small>
                                </div>
                            </div>
                            <div class="col-md">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('Confirm New Password') }}</label>
                                    <input type="password" class="form-control" name="new_password_confirmation">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('Password') }} (<small class="text-muted">{{ __('Enter your password to apply changes.') }}</small>)</label>
                                    <input type="password" class="form-control" name="password">
                                    @if ($errors->has('password'))
                                        <div class="text-danger">{{ $errors->first('password') }}</div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="float-end">
                            <button type="reset" class="btn btn-danger w-md">{{ __('Reset') }}</button>
                            <button type="submit" class="btn btn-success w-md">{{ __('Save') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- end row -->
@endsection

@section('script')
@endsection
