<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Clients\IpaymuService;
use App\Models\PaymentChannel;
use App\Models\PaymentMethod;

class PaymentChannelSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $ipaymu = new IpaymuService();
        $channels = $ipaymu->viewPaymentChannels();



$only = ['va','qris'];
        foreach ($channels['Data'] as $paymentMethod) {

            $type = $paymentMethod['Code'] ?? null;
            if(!in_array($type,$only)){
                continue;
            }


            foreach ($paymentMethod['Channels'] as $channel) {
                PaymentMethod::create([
                    'code' => $channel['Code'] ?? null,
                    'type' => $type,
                    'name' => $channel['Name'] ?? null,
                    'is_active' => ($channel['FeatureStatus'] ?? 'inactive') === 'active',
                    'bank_account_name' => null,
                    'bank_account' => null,
                    'image' => $channel['Logo'] ?? null,
                    'is_manual' => false, // default true karena tidak tersedia di API,
                    'provider' => 'ipaymu'

                ]);
            }
        }

    }
}
