<?php

namespace Database\Seeders;

use App\Clients\PaydisiniClient;
use App\Models\PaymentMethod;
use App\Models\Product;
use App\Models\ProductPackage;
use App\Models\Server;
use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Generate sample product data using a factory method, creating 10 entries for testing purposes.
        // User::factory(10)->create();



        PaymentMethod::create([
            'code' => 'bacmanual',
            'type' => 'Bank Transfer',
            'name' => 'Bca Manual',
            'fee' => 0,
            'bank_account_name' => 'PT. Interaksi Digital Indonesia',
            'bank_account' => '1234567890',
            'is_active' => true,
            'image' => 'https://belismm.com/storage/payment-method/104a0a5e43872c4bfe30e011b79c72d3.png'
        ]);
        // Creating an instance of a product named 'Interaksi.live Omnichannel Platform'
        $omni = Product::create([
            'code' => "interaksilive", // Product code
            'name' => "Interaksi.live Omnichannel Platform", // Product name
            'slug' => "interaksi-live-omnichannel-platform", // Product slug
            'description' => "A comprehensive omnichannel platform designed to integrate multiple communication channels seamlessly.",
            'image' => "https://wptanparibet.b-cdn.net/wp-content/uploads/2023/11/multi-device-e1699884511397.png",
            'supported_domain' => 'all'
        ]);

        // Creating an instance of another product named 'Whatsapp Gateway - MPWA'


        // Creating a set of packages for the Omnichannel Platform and the MPWA platform
        $omniPackages = [
            [
                'product_id' => $omni->id,
                'title' => 'trial',
                'description' => '<ul>
                            <li>3-day access to explore key features</li>
                            <li>No cost during trial period</li>
                            <li>Access to basic support</li>
                          </ul>',
                'price' => 0,
                'external' => null,
                'duration' => 3,
            ],
            [
                'product_id' => $omni->id,
                'title' => 'Normal',
                'description' => '<ul>
                            <li>Full access to all platform features</li>
                            <li>Monthly subscription with seamless integration options</li>
                            <li>Priority customer support</li>
                          </ul>',
                'price' => 150000,
                'external' => null,
                'duration' => 30,
            ],

        ];


        ProductPackage::insert($omniPackages);

        User::factory()->create([
            'name' => 'Test User',
            'email' => 'test@example.com',
        ]);
        User::create([
            'name' => 'Admin',
            'email' => 'admin@gmail.com',
            'password' => bcrypt('password'),
            'is_admin' => true,
        ]);
    }
}
