<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            // Buat kolom nullable dulu
            $table->foreignId('server_id')->nullable()->constrained('servers')->nullOnDelete();
            // nullOnDelete artinya kalau server-nya dihapus, server_id jadi null
        });
    }

    public function down(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            // Hapus foreign key dulu
            $table->dropForeign(['server_id']);
            // Baru hapus kolomnya
            $table->dropColumn('server_id');
        });
    }
};
