<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('social_channels', function (Blueprint $table) {
            $table->id();
            $table->foreignId('subscription_id')->references('id')->on('subscriptions')->onDelete('cascade');

            $table->enum('platform', ['messenger', 'whatsapp']);
            $table->string('channel_type'); // facebook_page, instagram_account, whatsapp_number
            $table->string('channel_id');
            $table->string('channel_name')->nullable();

            $table->text('access_token');
            $table->string('instagram_id')->nullable();
            $table->string('whatsapp_phone_id')->nullable();

            $table->json('meta_data')->nullable();
            $table->timestamp('webhook_verified_at')->nullable();
            $table->timestamp('connected_at')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('social_channels');
    }
};
