<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('servers', function (Blueprint $table) {
            $table->id();
            $table->string('host');
            $table->string('panel_url');
            $table->string('username');
            $table->longText('sshkey');
            $table->boolean('is_open')->default(true);
            $table->integer('port')->default(22);
            $table->string('dbuser')->nullable();
            $table->string('dbpass')->nullable();
            $table->string('panel_api_key')->nullable();
            $table->integer('webcount')->default(0);
           // $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('servers');
    }
};
