<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_methods', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique();

            $table->enum('type', ['VA', 'QRIS', 'Bank Transfer', 'EWALLET', 'RETAIL', 'OVO']);
            $table->string('name');
            $table->integer('fee')->default(0);
            $table->string('bank_account_name')->nullable();
            $table->string('bank_account')->nullable();
            $table->boolean('is_manual')->default(true);
            $table->boolean('is_active')->default(true);
            $table->string('image')->nullable();   $table->enum('payment_type', ['initial', 'renewal'])->default('initial');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_methods');
    }
};
