<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_number')->unique();
            $table->foreignId('subscription_id')->constrained('subscriptions')->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->integer('amount');
            $table->enum('status', ['paid', 'unpaid', 'canceled'])->default('unpaid');
            $table->json('payment_details')->nullable();
            $table->integer('tax')->nullable();
            $table->string('description')->nullable();
            $table->dateTime('expired_at')->nullable();
            $table->boolean('is_manual')->default(false);


            $table->enum('payment_type', ['initial', 'renewal'])->default('initial');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
