<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->string('product');
            $table->integer('price');
            $table->string('domain')->nullable();
            $table->enum('status', ['active', 'inactive', 'suspend', 'waiting', 'processing','canceled'])->default('inactive');
            $table->date('start_date')->nullable();
            $table->date('due_date')->nullable();
            $table->string('ns')->nullable();
            $table->json('details')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
