<?php

namespace App\Providers;

use App\Models\Payment;
use App\Models\Subscription;
use App\Observers\PaymentObserver;
use App\Observers\SubscriptionObserver;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Payment::observe(PaymentObserver::class);
        Subscription::observe(SubscriptionObserver::class);
    }
}
