<?php

namespace App\Observers;

use App\Clients\AapanelApi;
use App\Clients\CloudflareApi;
use App\Libs\Helper;
use App\Models\Server;
use Illuminate\Support\Facades\Log;

class SubscriptionObserver
{

    public function updated($subscription)
    {
        $user = $subscription->user;
        $server = Server::where('id', $subscription->server_id)->first();
        Log::info(json_encode($subscription));
        if ($subscription->isDirty('status') && $subscription->status !== 'active') {
            if ($subscription->status === 'inactive' || $subscription->status === 'suspend') {
                $user->notify((new \App\Notifications\SubscriptionInactive($subscription))->delay(now()->addSeconds(5)));
            }
            $cf = new CloudflareApi();
            $aapanel = new AapanelApi($server->panel_url, $server->panel_api_key);
            $isDomain = Helper::isDomain($subscription->domain);
            Log::info('here');
            try {
                Log::info('process deleteng web');
                $aapanel->deleteWebsite($subscription->web_id, $subscription->domain, true, true, true);
                if (!$isDomain) {
                    //  $sub = explode('.', $subscription->domain)[0];
                    $cf->deleteSubdomain($subscription->domain);
                } else {
                    $cf->deleteDomain($subscription->domain);
                }
            } catch (\Throwable $th) {
                //throw $th;
            }
        } else if ($subscription->isDirty('status') && $subscription->status == 'active') {

            $user->notify((new \App\Notifications\SubscriptionActive($subscription))->delay(now()->addSeconds(5)));
        }
    }
}
