<?php

namespace App\Observers;

use App\Clients\AapanelApi;
use App\Clients\CloudflareApi;
use App\Clients\ConfigWebsiteSsh;
use App\Jobs\UpdateSubscriptionStatus;
use App\Libs\Helper;
use App\Models\Payment;
use App\Models\Server;
use App\Notifications\InvoiceCanceled;
use App\Notifications\InvoicePaid;
use Illuminate\Support\Facades\Log;

class PaymentObserver
{


    public function updated(Payment $payment)
    {

        if ($payment->wasChanged('status') && $payment->status == 'paid') {
            UpdateSubscriptionStatus::dispatch($payment);
            $user = $payment->user;
            // if ($payment->payment_type === "initial") {

            //     try {
            //         $subscription = $payment->subscription;
            //         $subscription->status = 'active';
            //         $subscription->start_date = now();
            //         $domain = $subscription->domain;
            //         $isDomain = Helper::isDomain($domain);
            //         if (!$isDomain) {
            //             $detail =  $this->createWebsite($domain, $user);
            //             $subscription->details = json_encode($detail);
            //         } else {
            //             $subscription->ns = $this->getNameServer($domain);
            //         }

            //         $subscription->save();
            //     } catch (\Throwable $th) {
            //         Log::error($th->getMessage());
            //     }
            // } else if ($payment->payment_type === "renewal") {
            //     $subscription = $payment->subscription;
            //     $subscription->due_date = now()->addMonth();
            //     $subscription->save();
            // }
            $notification = (new InvoicePaid($payment))->delay(now()->addSeconds(5));
            $user->notify($notification);
        }

        if ($payment->wasChanged('status') && $payment->status == 'canceled') {
            $user = $payment->user;
            $subscription = $payment->subscription;
            $subscription->status = $subscription->status == "waiting" ? "canceled" : "inactive";
            $subscription->save();

            $notification = (new InvoiceCanceled($payment))->delay(now()->addSeconds(5));
            $user->notify($notification);
        }
    }
}
